/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;

public abstract class TopologicalSort<T, ID> {
    private final Map<ID, Collection<T>> mappedObjects = new LinkedHashMap<ID, Collection<T>>();
    private final Map<ID, Collection<ID>> requires = new LinkedHashMap<ID, Collection<ID>>();
    private final Map<ID, Collection<ID>> depends = new LinkedHashMap<ID, Collection<ID>>();

    protected abstract ID getId(T var1);

    protected abstract Collection<ID> getRequirements(ID var1);

    protected abstract Collection<ID> getDependencies(ID var1);

    public T[] sort(T[] objects) {
        if (objects.length <= 1) {
            return objects;
        }
        this.addAll(objects);
        return this.process(objects);
    }

    private T[] process(T[] results) {
        this.buildDependencyGraph();
        int resultsIndex = 0;
        ArrayList<ID> sortedByOutdegree = new ArrayList<ID>(this.requires.keySet());
        Comparator outdegreeSorter = (o1, o2) -> {
            assert (this.requires.containsKey(o1) && this.requires.containsKey(o2));
            int comparison = this.requires.get(o1).size() - this.requires.get(o2).size();
            if (comparison == 0) {
                return this.depends.get(o2).size() - this.depends.get(o1).size();
            }
            return comparison;
        };
        Collections.sort(sortedByOutdegree, outdegreeSorter);
        while (!sortedByOutdegree.isEmpty()) {
            if (!this.requires.get(sortedByOutdegree.get(0)).isEmpty()) {
                Collections.sort(sortedByOutdegree, outdegreeSorter);
            }
            LinkedList<Object> cycleToBeDone = new LinkedList<Object>();
            cycleToBeDone.add(sortedByOutdegree.remove(0));
            while (!cycleToBeDone.isEmpty()) {
                Object bundleId = cycleToBeDone.removeFirst();
                assert (this.depends.containsKey(bundleId) && this.requires.containsKey(bundleId));
                for (T ext : this.mappedObjects.get(bundleId)) {
                    results[resultsIndex++] = ext;
                }
                for (Object reqId : this.requires.get(bundleId)) {
                    if (!cycleToBeDone.contains(reqId)) {
                        cycleToBeDone.add(reqId);
                    }
                    sortedByOutdegree.remove(reqId);
                    this.depends.get(reqId).remove(bundleId);
                }
                this.requires.remove(bundleId);
                for (Object depId : this.depends.get(bundleId)) {
                    this.requires.get(depId).remove(bundleId);
                }
                this.depends.remove(bundleId);
            }
        }
        return results;
    }

    private void addAll(T[] objects) {
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            ID id = this.getId(o);
            Collection<T> exts = this.mappedObjects.get(id);
            if (exts == null) {
                exts = new LinkedHashSet<T>();
                this.mappedObjects.put(id, exts);
            }
            exts.add(o);
            ++n2;
        }
    }

    private void buildDependencyGraph() {
        this.requires.clear();
        this.depends.clear();
        for (ID id : this.mappedObjects.keySet()) {
            this.requires.put(id, new LinkedHashSet());
            this.depends.put(id, new LinkedHashSet());
        }
        for (ID subjectId : this.mappedObjects.keySet()) {
            Collection<ID> dependencies;
            assert (this.requires.containsKey(subjectId) && this.depends.containsKey(subjectId));
            Collection<ID> requirements = this.getRequirements(subjectId);
            if (requirements != null) {
                for (ID requiredId : requirements) {
                    assert (!requiredId.equals(subjectId)) : "self-cycles not supported";
                    if (!this.mappedObjects.containsKey(requiredId)) continue;
                    this.depends.get(requiredId).add(subjectId);
                    this.requires.get(subjectId).add(requiredId);
                }
            }
            if ((dependencies = this.getDependencies(subjectId)) == null) continue;
            for (ID dependentId : dependencies) {
                assert (!dependentId.equals(subjectId)) : "self-cycles not supported";
                if (!this.mappedObjects.containsKey(dependentId)) continue;
                this.requires.get(dependentId).add(subjectId);
                this.depends.get(subjectId).add(dependentId);
            }
        }
    }
}

