/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.canonical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.canonical.DefaultUMLSemanticChildrenStrategy;
import org.eclipse.uml2.uml.Continuation;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class LifelineSemanticChildrenStrategy
extends DefaultUMLSemanticChildrenStrategy {
    private final Switch<Boolean> visualizedInteractionFragmentSwitch = new UMLSwitch<Boolean>(){

        public Boolean caseInteractionFragment(InteractionFragment object) {
            return false;
        }

        public Boolean caseContinuation(Continuation object) {
            return true;
        }

        public Boolean caseDestructionOccurrenceSpecification(DestructionOccurrenceSpecification object) {
            return true;
        }

        public Boolean caseExecutionSpecification(ExecutionSpecification object) {
            return true;
        }

        public Boolean caseInteractionUse(InteractionUse object) {
            return true;
        }

        public Boolean caseStateInvariant(StateInvariant object) {
            return true;
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }
    };

    public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
        List _result;
        if (semanticFromEditPart instanceof Lifeline) {
            ArrayList result;
            Lifeline lifeline = (Lifeline)semanticFromEditPart;
            _result = result = Lists.newArrayList();
            this.collectCoveringExecutions(lifeline, result);
            lifeline.getCoveredBys().stream().filter(this::isVisualizedNonExecution).forEach(result::add);
        } else {
            _result = semanticFromEditPart instanceof InteractionOperand ? null : super.getCanonicalSemanticChildren(semanticFromEditPart, viewFromEditPart);
        }
        return _result;
    }

    protected void collectCoveringExecutions(Lifeline lifeline, Collection<? super ExecutionSpecification> result) {
        lifeline.getCoveredBys().stream().filter(OccurrenceSpecification.class::isInstance).map(OccurrenceSpecification.class::cast).flatMap(this::getExecutions).filter(Objects::nonNull).distinct().forEach(result::add);
    }

    protected boolean isVisualizedNonExecution(InteractionFragment fragment) {
        return !(fragment instanceof ExecutionSpecification) && (Boolean)this.visualizedInteractionFragmentSwitch.doSwitch((EObject)fragment) != false;
    }

    private Stream<ExecutionSpecification> getExecutions(OccurrenceSpecification occurrence) {
        Stream<ExecutionSpecification> result = occurrence instanceof ExecutionOccurrenceSpecification ? Stream.of(((ExecutionOccurrenceSpecification)occurrence).getExecution()) : EMFHelper.getUsages((EObject)occurrence).stream().filter(s -> s.getEStructuralFeature() == UMLPackage.Literals.EXECUTION_SPECIFICATION__START || s.getEStructuralFeature() == UMLPackage.Literals.EXECUTION_SPECIFICATION__FINISH).map(EStructuralFeature.Setting::getEObject).map(ExecutionSpecification.class::cast);
        return result;
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        List result = null;
        Lifeline lifeline = (Lifeline)TypeUtils.as((Object)semanticFromEditPart, Lifeline.class);
        Stream fromLifeline = lifeline == null ? Stream.empty() : lifeline.getCoveredBys().stream();
        ExecutionSpecification exec = (ExecutionSpecification)TypeUtils.as((Object)semanticFromEditPart, ExecutionSpecification.class);
        Stream<Object> fromExec = exec == null ? Stream.empty() : Stream.of(exec.getStart(), exec.getFinish());
        result = Stream.concat(fromLifeline, fromExec).filter(MessageEnd.class::isInstance).map(MessageEnd.class::cast).map(MessageEnd::getMessage).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return result;
    }

    public Object getSource(EObject connectionElement) {
        Object result;
        if (connectionElement instanceof Message) {
            MessageEnd end = ((Message)connectionElement).getSendEvent();
            result = end;
            result = this.resolveMessageEnd(end);
        } else {
            result = super.getSource(connectionElement);
        }
        return result;
    }

    private Object resolveMessageEnd(MessageEnd end) {
        Object result = end;
        if (end instanceof DestructionOccurrenceSpecification) {
            result = ((DestructionOccurrenceSpecification)end).getCovered();
        } else if (end instanceof OccurrenceSpecification) {
            Optional<Object> exec = this.getExecutions((OccurrenceSpecification)end).findFirst().map(Object.class::cast);
            result = exec.orElseGet(() -> {
                Optional<Object> lifeline = this.getCovered(end).map(Object.class::cast);
                return lifeline.orElse(end);
            });
        }
        return result;
    }

    protected Optional<Lifeline> getCovered(MessageEnd messageEnd) {
        Lifeline result = null;
        if (messageEnd instanceof OccurrenceSpecification) {
            result = ((MessageOccurrenceSpecification)messageEnd).getCovered();
        }
        return Optional.ofNullable(result);
    }

    public Object getTarget(EObject connectionElement) {
        Object result;
        if (connectionElement instanceof Message) {
            MessageEnd end = ((Message)connectionElement).getReceiveEvent();
            result = end;
            result = this.resolveMessageEnd(end);
        } else {
            result = super.getTarget(connectionElement);
        }
        return result;
    }
}

