/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.ui.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OneFileUIUtils {
    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorPart editor = OneFileUIUtils.findEditor(inputElement, false);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = OneFileUIUtils.getEditorInput(inputElement);
        if (input != null && (p = OneFileUIUtils.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    private static IEditorPart findEditor(Object inputElement, boolean activate) {
        IPapyrusFile cu;
        if (inputElement instanceof IPapyrusFile && (cu = (IPapyrusFile)inputElement) != null) {
            IWorkbenchPage page = OneFileUIUtils.getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorPart editor = ref.getEditor(false);
                if (editor != null) {
                    IEditorInput editorInput = editor.getEditorInput();
                    if (cu.getMainFile().equals(editorInput.getAdapter(IFile.class))) {
                        if (activate && page.getActivePart() != editor) {
                            page.activate((IWorkbenchPart)editor);
                        }
                        return editor;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws PartInitException {
        if (inputElement instanceof IFile) {
            return OneFileUIUtils.openInEditor((IFile)inputElement, activate);
        }
        IEditorPart editor = OneFileUIUtils.findEditor(inputElement, activate);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = OneFileUIUtils.getEditorInput(inputElement);
        if (input == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile.ui", "not found"));
        }
        return OneFileUIUtils.openInEditor(input, OneFileUIUtils.getEditorID(input), activate);
    }

    private static IEditorInput getEditorInput(Object inputElement) {
        if (inputElement instanceof IFile) {
            IFile file = (IFile)inputElement;
            return new FileEditorInput(file);
        }
        return null;
    }

    public static String getEditorID(IEditorInput input) throws PartInitException {
        Assert.isNotNull((Object)input);
        IEditorDescriptor editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : IDE.getEditorDescriptor((String)input.getName());
        return editorDescriptor.getId();
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        if (file == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile.ui", "not found"));
        }
        IWorkbenchPage p = OneFileUIUtils.getActivePage();
        if (p == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile.ui", "not found"));
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        return editorPart;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        Assert.isNotNull((Object)input);
        Assert.isNotNull((Object)editorID);
        IWorkbenchPage p = OneFileUIUtils.getActivePage();
        if (p == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile.ui", "not found"));
        }
        IEditorPart editorPart = p.openEditor(input, editorID, activate);
        return editorPart;
    }
}

