/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.export.utils.SelectionHelper;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.HTMLExportHelper;
import org.eclipse.papyrus.uml.export.HTMLExportRunner;
import org.eclipse.papyrus.uml.export.extension.HTMLExtensionRegistry;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportHtmlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (Activator.getDefault().isDebugging()) {
            Activator.debug("Start html export in debug mode");
        }
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        ModelSet modelSetSelection = null;
        try {
            modelSetSelection = ServiceUtilsForSelection.getInstance().getModelSet((Object)selection);
        }
        catch (ServiceException e) {
            IFile file = SelectionHelper.convertSelection2File((ISelection)selection);
            URI diFileUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            modelSetSelection = this.initialiseModelSet(diFileUri);
        }
        List<Diagram> allDiagrams = ExportHtmlHandler.getAllDiagrams(modelSetSelection);
        URI uriWithoutExtension = modelSetSelection.getURIWithoutExtension();
        URI resolvedFile = CommonPlugin.resolve((URI)uriWithoutExtension);
        String fileString = resolvedFile.toFileString();
        Path targetDirectoryPath = new Path(fileString);
        List<String> activatePref = ExportHtmlHandler.parseList(Activator.getDefault().getPreferenceStore().getString("active.strategy"));
        if (activatePref.isEmpty()) {
            activatePref = HTMLExtensionRegistry.getInstance().getAllExtension().stream().map(IExtension::getUniqueIdentifier).collect(Collectors.toList());
        }
        HTMLExportHelper helperFromPrefs = HTMLExtensionRegistry.getHelperFromPrefs(activatePref);
        HTMLExportRunner.generateHtmlWebSite(targetDirectoryPath, allDiagrams, helperFromPrefs);
        this.refreshworkspace();
        if (Activator.getDefault().isDebugging()) {
            Activator.debug("End html export in debug mode");
        }
        return null;
    }

    public static List<Diagram> getAllDiagrams(ModelSet modelSet) {
        Iterable allNotations = NotationUtils.getAllNotations((ResourceSet)modelSet, Diagram.class);
        ArrayList<Diagram> copy = new ArrayList<Diagram>();
        Iterator iterator = allNotations.iterator();
        while (iterator.hasNext()) {
            copy.add((Diagram)iterator.next());
        }
        return copy;
    }

    public static List<String> parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    private void refreshworkspace() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            root.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private ModelSet initialiseModelSet(URI diFileUri) {
        ExtensionServicesRegistry service = null;
        try {
            service = new ExtensionServicesRegistry();
        }
        catch (ServiceException e) {
            Activator.log(e);
            service = new ServicesRegistry();
        }
        ServiceDescriptor descriptor = new ServiceDescriptor(ModelSet.class, ModelSetServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        descriptor = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        try {
            service.startServicesByClassKeys(new Class[]{ModelSet.class, TransactionalEditingDomain.class});
        }
        catch (ServiceException e) {
            Activator.log(e);
        }
        ModelSet modelSet = null;
        try {
            modelSet = ServiceUtils.getInstance().getModelSet((Object)service);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSet == null) {
            modelSet = new ModelSet();
            try {
                ModelSetServiceFactory.setServiceRegistry((ResourceSet)modelSet, (ServicesRegistry)service);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        ModelsReader modelsReader = new ModelsReader();
        modelsReader.readModel(modelSet);
        try {
            modelSet.loadModels(diFileUri);
        }
        catch (ModelMultiException e) {
            Activator.log(e);
        }
        modelSet.getTransactionalEditingDomain();
        return modelSet;
    }
}

