/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class CustomDurationConstraintCreateCommand
extends EditElementCommand {
    public CustomDurationConstraintCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        EditPart firstTarget = (EditPart)request.getParameter("FIRST_TARGET");
        EditPart secondTarget = (EditPart)request.getParameter("SECOND_TARGET");
        DurationConstraint durationConstraint = UMLFactory.eINSTANCE.createDurationConstraint();
        NamedElement firstTargetElement = (NamedElement)((View)firstTarget.getModel()).getElement();
        NamedElement secondTargetElement = (NamedElement)((View)secondTarget.getModel()).getElement();
        Package containingPackage = EcoreUtils.getContaining(request.getContainer(), Package.class);
        if (containingPackage == null) {
            return CommandResult.newErrorCommandResult((String)"The container must be in a Package");
        }
        containingPackage.getPackagedElements().add((Object)durationConstraint);
        durationConstraint.getConstrainedElements().clear();
        durationConstraint.getFirstEvents().clear();
        if (firstTargetElement == secondTargetElement) {
            durationConstraint.getConstrainedElements().add((Object)firstTargetElement);
        } else {
            durationConstraint.getConstrainedElements().add((Object)firstTargetElement);
            durationConstraint.getConstrainedElements().add((Object)secondTargetElement);
            durationConstraint.getFirstEvents().add((Object)Boolean.TRUE);
            durationConstraint.getFirstEvents().add((Object)Boolean.FALSE);
        }
        DurationInterval durationInterval = UMLFactory.eINSTANCE.createDurationInterval();
        durationConstraint.setSpecification((ValueSpecification)durationInterval);
        Duration minTime = UMLFactory.eINSTANCE.createDuration();
        Duration maxTime = UMLFactory.eINSTANCE.createDuration();
        containingPackage.getPackagedElements().add((Object)minTime);
        containingPackage.getPackagedElements().add((Object)maxTime);
        durationInterval.setMin((ValueSpecification)minTime);
        durationInterval.setMax((ValueSpecification)maxTime);
        LiteralString minExpr = UMLFactory.eINSTANCE.createLiteralString();
        LiteralString maxExpr = UMLFactory.eINSTANCE.createLiteralString();
        minTime.setExpr((ValueSpecification)minExpr);
        maxTime.setExpr((ValueSpecification)maxExpr);
        minExpr.setValue("d1");
        maxExpr.setValue("d2");
        request.setNewElement((EObject)durationConstraint);
        return CommandResult.newOKCommandResult((Object)durationConstraint);
    }
}

