/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class ECollections2 {
    private ECollections2() {
    }

    public static <E> ImmutableEListBuilder<E> immutableEListBuilder() {
        return new ImmutableEListBuilder();
    }

    public static final class ImmutableEListBuilder<E> {
        private final ImmutableEListBuilderHelper<E> helper = new ImmutableEListBuilderHelper();

        ImmutableEListBuilder() {
        }

        public ImmutableEListBuilder<E> add(E element) {
            this.helper.add(element);
            return this;
        }

        public ImmutableEListBuilder<E> add(E element1, E element2) {
            this.helper.add(element1);
            this.helper.add(element2);
            return this;
        }

        public ImmutableEListBuilder<E> add(E element1, E element2, E element3) {
            this.helper.add(element1);
            this.helper.add(element2);
            this.helper.add(element3);
            return this;
        }

        @SafeVarargs
        public final ImmutableEListBuilder<E> add(E element1, E element2, E element3, E element4, E ... elements) {
            this.helper.add(element1);
            this.helper.add(element2);
            this.helper.add(element3);
            this.helper.add(element4);
            if (elements.length > 0) {
                this.helper.addAll(elements);
            }
            return this;
        }

        public ImmutableEListBuilder<E> addAll(Iterable<? extends E> elements) {
            this.helper.addAll(elements);
            return this;
        }

        public ImmutableEListBuilder<E> sort(Comparator<? super E> comparator) {
            ECollections.sort(this.helper, comparator);
            return this;
        }

        public EList<E> build() {
            return this.helper.build();
        }
    }

    private static final class ImmutableEListBuilderHelper<E>
    extends BasicEList<E> {
        private static final long serialVersionUID = 1L;

        private ImmutableEListBuilderHelper() {
        }

        void addAll(Iterable<? extends E> elements) {
            if (elements instanceof Collection) {
                this.addAll((Collection)elements);
            } else {
                for (E next : elements) {
                    this.add(next);
                }
            }
        }

        @SafeVarargs
        final void addAll(E ... elements) {
            int i = 0;
            while (i < elements.length) {
                this.add(elements[i]);
                ++i;
            }
        }

        EList<E> build() {
            return new BasicEList.UnmodifiableEList(this.size, this.data);
        }
    }
}

