/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.wizard.CategoriesWizardUtils;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ChooseCategoriesSelectionWidget;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueSelectionWidget;
import org.eclipse.papyrus.infra.widgets.wizard.pages.MultipleValueEditAndSelectionWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;

public class SelectCategoriesWizardPage
extends MultipleValueEditAndSelectionWizardPage {
    public static final String DEFAULT_SELECT_CATEGORIES_PAGE_NAME = Messages.SelectCategoriesWizardPage_SelectCategoriesPage;
    public static final String DEFAULT_SELECT_CATEGORIES_TITLE = Messages.SelectCategoriesWizardPage_SelectCategoriesToListenInTheTreeTable;
    private IElementSelector selector;
    private IElementSelectionListener selectorListener;

    public SelectCategoriesWizardPage(IElementSelector selector) {
        this(DEFAULT_SELECT_CATEGORIES_PAGE_NAME, DEFAULT_SELECT_CATEGORIES_TITLE, null, selector);
    }

    public SelectCategoriesWizardPage(String pageName, String pageTitle, ImageDescriptor defaultImage, IElementSelector selector) {
        super(pageName, pageTitle, defaultImage, selector, false, true, -1);
    }

    protected MultipleValueSelectionWidget createWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        this.selector = selector;
        this.selectorListener = new SelectorListener();
        this.selector.addElementSelectionListener(this.selectorListener);
        return new ChooseCategoriesSelectionWidget(selector, unique, ordered, upperBound){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                SelectCategoriesWizardPage.this.validate();
            }

            public void doubleClick(DoubleClickEvent event) {
                super.doubleClick(event);
                SelectCategoriesWizardPage.this.validate();
            }
        };
    }

    public void dispose() {
        if (this.selector != null) {
            this.selector.removeElementSelectionListener(this.selectorListener);
            this.selector = null;
        }
        super.dispose();
    }

    protected void validate() {
        List selection = this.getWidget().getSelection();
        ArrayList<Integer> incompleteDepth = new ArrayList<Integer>();
        for (Object current : selection) {
            Assert.isTrue((boolean)(current instanceof ITreeItemAxis));
            ITreeItemAxis rootItem = (ITreeItemAxis)current;
            Assert.isTrue((boolean)CategoriesWizardUtils.isRootItem(rootItem));
            for (ITreeItemAxis depthItem : rootItem.getChildren()) {
                int depth;
                Assert.isTrue((boolean)CategoriesWizardUtils.isDepthItem(depthItem));
                if (!depthItem.getChildren().isEmpty() || (depth = Integer.valueOf(depthItem.getElement().toString()).intValue()) == 0) continue;
                incompleteDepth.add(depth);
            }
        }
        if (incompleteDepth.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            StringBuilder builder = new StringBuilder(NLS.bind((String)"The following depths don't have categories {0}", (Object)((Object)incompleteDepth).toString()));
            this.setErrorMessage(builder.toString());
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private class SelectorListener
    implements IElementSelectionListener {
        private SelectorListener() {
        }

        public void addElements(Object[] elements) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SelectCategoriesWizardPage.this.validate();
                }
            });
        }
    }
}

