/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.print;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.Direction;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.print.config.PrintConfigAttributes;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeHelper;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LayerPrinter {
    private final List<PrintTarget> printTargets = new ArrayList<PrintTarget>();
    public static final int FOOTER_HEIGHT_IN_PRINTER_DPI = 300;
    final SimpleDateFormat dateFormat;
    private final String footerDate;
    private final String footerPagePattern;
    private final int footerHeight;
    protected boolean preRender = true;
    private final Direction fittingMode;
    private final boolean stretch;
    private boolean join = false;
    private boolean calculatePageCount = true;

    public LayerPrinter(ILayer layer, IConfigRegistry configRegistry) {
        this(layer, null, configRegistry, false);
    }

    public LayerPrinter(ILayer layer, ILayer repeatHeaderLayer, IConfigRegistry configRegistry) {
        this(layer, repeatHeaderLayer, configRegistry, false);
    }

    public LayerPrinter(ILayer layer, IConfigRegistry configRegistry, boolean repeat) {
        this(layer, null, configRegistry, repeat);
    }

    public LayerPrinter(ILayer layer, ILayer repeatHeaderLayer, IConfigRegistry configRegistry, boolean repeat) {
        this.printTargets.add(new PrintTarget(layer, repeatHeaderLayer, configRegistry, repeat));
        Integer fh = configRegistry.getConfigAttribute(PrintConfigAttributes.FOOTER_HEIGHT, "NORMAL", new String[0]);
        this.footerHeight = fh != null ? fh : 300;
        String pagePattern = configRegistry.getConfigAttribute(PrintConfigAttributes.FOOTER_PAGE_PATTERN, "NORMAL", new String[0]);
        this.footerPagePattern = pagePattern != null ? pagePattern : Messages.getString("Printer.page");
        String configuredFormat = configRegistry.getConfigAttribute(PrintConfigAttributes.DATE_FORMAT, "NORMAL", new String[0]);
        this.dateFormat = configuredFormat != null ? new SimpleDateFormat(configuredFormat) : new SimpleDateFormat("EEE, d MMM yyyy HH:mm a");
        this.footerDate = this.dateFormat.format(new Date());
        Direction configuredFittingMode = configRegistry.getConfigAttribute(PrintConfigAttributes.FITTING_MODE, "NORMAL", new String[0]);
        this.fittingMode = configuredFittingMode != null ? configuredFittingMode : Direction.NONE;
        Boolean configureStretching = configRegistry.getConfigAttribute(PrintConfigAttributes.STRETCH, "NORMAL", new String[0]);
        this.stretch = configureStretching != null ? configureStretching : false;
    }

    public void addPrintTarget(ILayer layer, IConfigRegistry configRegistry) {
        this.addPrintTarget(layer, null, configRegistry);
    }

    public void addPrintTarget(ILayer layer, ILayer repeatHeaderLayer, IConfigRegistry configRegistry) {
        this.printTargets.add(new PrintTarget(layer, repeatHeaderLayer, configRegistry, false));
    }

    public void joinPrintTargets(boolean join) {
        this.join = join;
    }

    private int getRepeatPrintTargetHeight() {
        int result = 0;
        for (PrintTarget target : this.printTargets) {
            if (!target.repeat) continue;
            result += target.layer.getHeight();
        }
        return result;
    }

    private float[] getRepeatPrintTargetScaleFactor(Printer printer) {
        float[] result = new float[]{0.0f, 0.0f};
        if (this.printTargets.get(0).repeat) {
            result = this.computeLayerScaleFactor(this.printTargets.get(0).layer, printer);
        }
        return result;
    }

    private float[] computeScaleFactor(ILayer layer, Printer printer, boolean dpi) {
        Point screenDPI = Display.getDefault().getDPI();
        Point printerDPI = printer.getDPI();
        float sfX = Float.valueOf(printerDPI.x).floatValue() / Float.valueOf(screenDPI.x).floatValue();
        float sfY = Float.valueOf(printerDPI.y).floatValue() / Float.valueOf(screenDPI.y).floatValue();
        if (!dpi && this.fittingMode != Direction.NONE) {
            Rectangle total = this.getTotalArea(layer);
            if (this.join || this.printTargets.get(0).repeat) {
                total.height = 0;
                for (PrintTarget target : this.printTargets) {
                    total.height += target.layer.getHeight();
                }
            }
            Rectangle print = this.computePrintArea(printer);
            float pixelX = Float.valueOf(print.width).floatValue() / Float.valueOf(total.width).floatValue();
            float pixelY = (Float.valueOf(print.height).floatValue() - (float)this.getFooterHeightInPrinterDPI()) / Float.valueOf(total.height).floatValue();
            if (pixelX > sfX && !this.stretch) {
                pixelX = sfX;
            }
            if (pixelY > sfY) {
                pixelY = sfY;
            }
            switch (this.fittingMode) {
                case HORIZONTAL: {
                    return new float[]{pixelX, pixelX};
                }
                case VERTICAL: {
                    return new float[]{pixelY, pixelY};
                }
                case BOTH: {
                    return new float[]{pixelX, pixelY};
                }
            }
        }
        return new float[]{sfX, sfY};
    }

    private float[] computeLayerScaleFactor(ILayer layer, Printer printer) {
        float[] scaleFactor = null;
        if (this.fittingMode == Direction.NONE || !this.join && !this.printTargets.get(0).repeat || this.stretch) {
            scaleFactor = this.computeScaleFactor(layer, printer, false);
        } else {
            for (PrintTarget tempTarget : this.printTargets) {
                float[] tempFactor = this.computeScaleFactor(tempTarget.layer, printer, false);
                if (scaleFactor == null) {
                    scaleFactor = tempFactor;
                    continue;
                }
                scaleFactor[0] = Math.min(scaleFactor[0], tempFactor[0]);
                scaleFactor[1] = Math.min(scaleFactor[1], tempFactor[1]);
            }
        }
        return scaleFactor;
    }

    private Rectangle getTotalArea(ILayer layer) {
        return new Rectangle(0, 0, layer.getWidth(), layer.getHeight());
    }

    private int getPageCount(Printer printer) {
        int result = 0;
        int available = -1;
        float[] prevScaleFactor = null;
        for (PrintTarget target : this.printTargets) {
            if (target.repeat) continue;
            int[] layerResult = this.getPageCount(target, printer, available, prevScaleFactor);
            result += layerResult[0] * layerResult[1];
            if (this.join && available > 0) {
                --result;
            }
            if ((available = layerResult[2]) < 0) continue;
            prevScaleFactor = this.computeLayerScaleFactor(target.layer, printer);
        }
        return result;
    }

    private int[] getPageCount(PrintTarget target, Printer printer, int available, float[] prevScaleFactor) {
        Rectangle printArea = this.computePrintArea(printer);
        float[] scaleFactor = this.computeLayerScaleFactor(target.layer, printer);
        Integer[] gridLineWidth = this.getGridLineWidth(target.configRegistry);
        int numOfHorizontalPages = 0;
        int pageWidth = Math.round(Float.valueOf((float)printArea.width / scaleFactor[0]).floatValue());
        int endX = 0;
        while (endX < target.layer.getWidth()) {
            int colPos = target.layer.getColumnPositionByX(endX += pageWidth);
            if (colPos >= 0) {
                ILayerCell cell = this.findColumnCellForBounds(target.layer, colPos);
                if (cell != null) {
                    Rectangle cellBounds = cell.getBounds();
                    if (cellBounds.x < endX) {
                        endX -= endX - cellBounds.x;
                    }
                }
            } else {
                endX = target.layer.getWidth();
            }
            ++numOfHorizontalPages;
        }
        int numOfVerticalPages = 0;
        int repeatPrintTargetHeightInDpi = target.repeat ? 0 : Math.round(Float.valueOf((float)this.getRepeatPrintTargetHeight() * this.getRepeatPrintTargetScaleFactor(printer)[1]).floatValue());
        int headerHeightInDpi = target.repeatHeaderLayer != null ? Math.round(Float.valueOf((float)target.repeatHeaderLayer.getHeight() * scaleFactor[1]).floatValue()) : 0;
        int pageHeight = Math.round(Float.valueOf((float)(printArea.height - repeatPrintTargetHeightInDpi - headerHeightInDpi - this.getFooterHeightInPrinterDPI()) / scaleFactor[1]).floatValue());
        int firstPageHeight = available < 0 ? Math.round(Float.valueOf((float)(printArea.height - repeatPrintTargetHeightInDpi - this.getFooterHeightInPrinterDPI()) / scaleFactor[1]).floatValue()) : Math.round(Float.valueOf((float)Math.round(Float.valueOf((float)available * prevScaleFactor[1]).floatValue()) / scaleFactor[1]).floatValue());
        int endY = 0;
        int added = 0;
        int remaining = -1;
        while (endY < target.layer.getHeight()) {
            added = numOfVerticalPages == 0 ? firstPageHeight : pageHeight;
            int rowPos = target.layer.getRowPositionByY(endY += added);
            if (rowPos >= 0) {
                ILayerCell cell = this.findRowCellForBounds(target.layer, rowPos);
                if (cell != null) {
                    Rectangle cellBounds = cell.getBounds();
                    if (cellBounds.y < endY) {
                        endY -= endY - cellBounds.y;
                    }
                }
            } else {
                if (this.join) {
                    remaining = (numOfVerticalPages == 0 ? firstPageHeight : pageHeight) - (target.layer.getHeight() - (endY - added));
                }
                endY = target.layer.getHeight();
            }
            ++numOfVerticalPages;
        }
        if (gridLineWidth[0] == null) {
            target.configRegistry.unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH);
        }
        return new int[]{numOfHorizontalPages, numOfVerticalPages, remaining};
    }

    private ILayerCell findColumnCellForBounds(ILayer layer, int colPos) {
        int rowPos = 0;
        ILayerCell cell = layer.getCellByPosition(colPos, rowPos);
        while (cell != null && cell.isSpannedCell()) {
            cell = layer.getCellByPosition(colPos, ++rowPos);
        }
        return cell;
    }

    private ILayerCell findRowCellForBounds(ILayer layer, int rowPos) {
        int colPos = 0;
        ILayerCell cell = layer.getCellByPosition(colPos, rowPos);
        while (cell != null && cell.isSpannedCell()) {
            cell = layer.getCellByPosition(++colPos, rowPos);
        }
        return cell;
    }

    protected int getFooterHeightInPrinterDPI() {
        return this.footerHeight;
    }

    protected Integer[] getGridLineWidth(IConfigRegistry configRegistry) {
        Integer width;
        Integer gridLineWidth = width = configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, "NORMAL", new String[0]);
        if (width == null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, 2);
            gridLineWidth = 2;
        }
        return new Integer[]{width, gridLineWidth};
    }

    public void print(Shell shell) {
        Printer printer = this.setupPrinter(shell);
        if (printer == null) {
            return;
        }
        Display.getDefault().asyncExec((Runnable)new PrintJob(printer));
    }

    private boolean shouldPrint(PrinterData printerData, int totalPageCount) {
        if (printerData.scope == 1) {
            return totalPageCount >= printerData.startPage && totalPageCount <= printerData.endPage;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Printer setupPrinter(Shell shell) {
        printDialog = new PrintDialog(shell);
        printDialog.setStartPage(1);
        printDialog.setScope(0);
        if (this.calculatePageCount) {
            if (this.preRender) {
                for (PrintTarget target : this.printTargets) {
                    AutoResizeHelper.autoResize(PrintTarget.access$0(target), PrintTarget.access$1(target));
                }
            }
            for (PrintTarget target : this.printTargets) {
                PrintTarget.access$0(target).doCommand(new TurnViewportOffCommand());
            }
            try {
                defaultPrinter = new Printer();
                pageCount = this.getPageCount(defaultPrinter);
                defaultPrinter.dispose();
                printDialog.setEndPage(pageCount);
            }
            finally {
                ** for (target : this.printTargets)
            }
lbl-1000:
            // 1 sources

            {
                PrintTarget.access$0(target).doCommand(new TurnViewportOnCommand());
                continue;
            }
        }
lbl24:
        // 3 sources

        if ((printerData = printDialog.open()) == null) {
            return null;
        }
        return new Printer(printerData);
    }

    private Rectangle computePrintArea(Printer printer) {
        int bottom;
        int top;
        int right;
        Rectangle rect = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        dpi.x /= 2;
        dpi.y /= 2;
        int left = trim.x + dpi.x;
        if (left < rect.x) {
            left = rect.x;
        }
        if ((right = rect.width + trim.x + trim.width - dpi.x) > rect.width) {
            right = rect.width;
        }
        if ((top = trim.y + dpi.y) < rect.y) {
            top = rect.y;
        }
        if ((bottom = rect.height + trim.y + trim.height - dpi.y) > rect.height) {
            bottom = rect.height;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public void enablePreRendering() {
        this.preRender = true;
    }

    public void disablePreRendering() {
        this.preRender = false;
    }

    public void enablePageCountCalculation() {
        this.calculatePageCount = true;
    }

    public void disablePageCountCalculation() {
        this.calculatePageCount = false;
    }

    static /* synthetic */ List access$0(LayerPrinter layerPrinter) {
        return layerPrinter.printTargets;
    }

    static /* synthetic */ int access$1(LayerPrinter layerPrinter, Printer printer) {
        return layerPrinter.getPageCount(printer);
    }

    static /* synthetic */ float[] access$2(LayerPrinter layerPrinter, ILayer iLayer, Printer printer) {
        return layerPrinter.computeLayerScaleFactor(iLayer, printer);
    }

    static /* synthetic */ float[] access$3(LayerPrinter layerPrinter, ILayer iLayer, Printer printer, boolean bl) {
        return layerPrinter.computeScaleFactor(iLayer, printer, bl);
    }

    static /* synthetic */ Rectangle access$4(LayerPrinter layerPrinter, Printer printer) {
        return layerPrinter.computePrintArea(printer);
    }

    static /* synthetic */ int access$5(LayerPrinter layerPrinter) {
        return layerPrinter.getRepeatPrintTargetHeight();
    }

    static /* synthetic */ int[] access$6(LayerPrinter layerPrinter, PrintTarget printTarget, Printer printer, int n, float[] fArray) {
        return layerPrinter.getPageCount(printTarget, printer, n, fArray);
    }

    static /* synthetic */ ILayerCell access$7(LayerPrinter layerPrinter, ILayer iLayer, int n) {
        return layerPrinter.findRowCellForBounds(iLayer, n);
    }

    static /* synthetic */ ILayerCell access$8(LayerPrinter layerPrinter, ILayer iLayer, int n) {
        return layerPrinter.findColumnCellForBounds(iLayer, n);
    }

    static /* synthetic */ boolean access$9(LayerPrinter layerPrinter, PrinterData printerData, int n) {
        return layerPrinter.shouldPrint(printerData, n);
    }

    static /* synthetic */ boolean access$10(LayerPrinter layerPrinter) {
        return layerPrinter.join;
    }

    private class PrintJob
    implements Runnable {
        private final Printer printer;

        private PrintJob(Printer printer) {
            this.printer = printer;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block31: {
                if (!this.printer.startJob("NatTable")) break block31;
                gc = new GC((Drawable)this.printer);
                for (PrintTarget target : LayerPrinter.access$0(LayerPrinter.this)) {
                    if (LayerPrinter.this.preRender) {
                        AutoResizeHelper.autoResize(PrintTarget.access$0(target), PrintTarget.access$1(target));
                    }
                    PrintTarget.access$0(target).doCommand(new TurnViewportOffCommand());
                }
                try {
                    currentPage = 1;
                    totalPageCount = LayerPrinter.access$1(LayerPrinter.this, this.printer);
                    repeatHeaderGridLineWidth = null;
                    repeatScaleFactor = null;
                    available = -1;
                    prevScaleFactor = null;
                    newPage = true;
                    pageStarted = false;
                    for (PrintTarget target : LayerPrinter.access$0(LayerPrinter.this)) {
                        if (PrintTarget.access$2(target)) {
                            repeatHeaderGridLineWidth = LayerPrinter.this.getGridLineWidth(PrintTarget.access$1(target));
                            repeatScaleFactor = LayerPrinter.access$2(LayerPrinter.this, PrintTarget.access$0(target), this.printer);
                            continue;
                        }
                        scaleFactor = LayerPrinter.access$2(LayerPrinter.this, PrintTarget.access$0(target), this.printer);
                        dpiFactor = LayerPrinter.access$3(LayerPrinter.this, PrintTarget.access$0(target), this.printer, true);
                        availablePixel = available;
                        if (available > 0) {
                            prevDPI = Math.round(Float.valueOf((float)available * prevScaleFactor[1]).floatValue());
                            availablePixel = Math.round(Float.valueOf((float)prevDPI / scaleFactor[1]).floatValue());
                        }
                        gridLineWidth = LayerPrinter.this.getGridLineWidth(PrintTarget.access$1(target));
                        try {
                            PrintTarget.access$0(target).doCommand(new CalculateSummaryRowValuesCommand());
                            PrintTarget.access$0(target).doCommand(new DisableFormulaCachingCommand());
                            this.setLayerSize(target, this.printer.getPrinterData());
                            printerClientArea = LayerPrinter.access$4(LayerPrinter.this, this.printer);
                            printBoundsWidth = Math.round(Float.valueOf((float)printerClientArea.width / scaleFactor[0]).floatValue());
                            repeatPrintTargetHeight = LayerPrinter.access$5(LayerPrinter.this);
                            repeatPrintTargetHeightInDpi = (float)repeatPrintTargetHeight * (repeatScaleFactor != null ? repeatScaleFactor[1] : 0.0f);
                            headerHeight = PrintTarget.access$3(target) != null ? PrintTarget.access$3(target).getHeight() : 0;
                            headerHeightDPI = (float)headerHeight * scaleFactor[1];
                            printBoundsHeight = Math.round(Float.valueOf(((float)printerClientArea.height - repeatPrintTargetHeightInDpi - headerHeightDPI - (float)LayerPrinter.this.getFooterHeightInPrinterDPI()) / scaleFactor[1]).floatValue());
                            firstPagePrintBoundsHeight = available < 0 ? Math.round(Float.valueOf(((float)printerClientArea.height - repeatPrintTargetHeightInDpi - (float)LayerPrinter.this.getFooterHeightInPrinterDPI()) / scaleFactor[1]).floatValue()) : availablePixel;
                            pageCount = LayerPrinter.access$6(LayerPrinter.this, target, this.printer, available, prevScaleFactor);
                            startY = 0;
                            verticalPageNumber = 0;
                            while (verticalPageNumber < pageCount[1]) {
                                pbh = verticalPageNumber == 0 ? firstPagePrintBoundsHeight : printBoundsHeight;
                                endY = startY + pbh;
                                rowPos = PrintTarget.access$0(target).getRowPositionByY(endY);
                                if (rowPos >= 0 && (cell = LayerPrinter.access$7(LayerPrinter.this, PrintTarget.access$0(target), rowPos)) != null) {
                                    cellBounds = cell.getBounds();
                                    if (cellBounds.y < endY) {
                                        pbh -= endY - cellBounds.y;
                                    }
                                }
                                startX = 0;
                                horizontalPageNumber = 0;
                                while (horizontalPageNumber < pageCount[0]) {
                                    printBounds = new Rectangle(startX, startY, printBoundsWidth, pbh);
                                    endX = startX + printBounds.width;
                                    colPos = PrintTarget.access$0(target).getColumnPositionByX(endX);
                                    if (colPos >= 0 && (cell = LayerPrinter.access$8(LayerPrinter.this, PrintTarget.access$0(target), colPos)) != null) {
                                        cellBounds = cell.getBounds();
                                        if (cellBounds.x < endX) {
                                            printBounds.width -= endX - cellBounds.x;
                                        }
                                    }
                                    footerBounds = new Rectangle(Math.round(Float.valueOf((float)printerClientArea.width / dpiFactor[0] * (float)horizontalPageNumber).floatValue()), Math.round(Float.valueOf((float)(printerClientArea.height - LayerPrinter.this.getFooterHeightInPrinterDPI()) / dpiFactor[1] * (float)verticalPageNumber).floatValue()), Math.round(Float.valueOf((float)printerClientArea.width / dpiFactor[0]).floatValue()), Math.round(Float.valueOf((float)(printerClientArea.height - LayerPrinter.this.getFooterHeightInPrinterDPI()) / dpiFactor[1]).floatValue()));
                                    if (LayerPrinter.access$9(LayerPrinter.this, this.printer.getPrinterData(), currentPage)) {
                                        if (pageStarted) {
                                            this.printer.endPage();
                                            newPage = true;
                                        }
                                        if (newPage) {
                                            this.printer.startPage();
                                            pageStarted = true;
                                            newPage = false;
                                        }
                                        if (!pageStarted && !newPage) {
                                            pageStarted = true;
                                        }
                                        printerTransform = new Transform((Device)this.printer);
                                        repeatTransform = new Transform((Device)this.printer);
                                        headerTransform = new Transform((Device)this.printer);
                                        footerTransform = new Transform((Device)this.printer);
                                        intersect = new Rectangle(0, 0, PrintTarget.access$0(target).getWidth(), PrintTarget.access$0(target).getHeight());
                                        intersect = printBounds.intersection(intersect);
                                        this.configureScalingTransform(printerTransform, scaleFactor, printerClientArea, intersect);
                                        this.configureScalingTransform(repeatTransform, repeatScaleFactor != null ? repeatScaleFactor : scaleFactor, printerClientArea, intersect);
                                        this.configureScalingTransform(headerTransform, scaleFactor, printerClientArea, intersect);
                                        if (repeatPrintTargetHeight > 0) {
                                            repeatTransform.translate(0.0f, (float)startY);
                                            gc.setTransform(repeatTransform);
                                            repeatIntersect = new Rectangle(0, 0, PrintTarget.access$0((PrintTarget)LayerPrinter.access$0(LayerPrinter.this).get(0)).getWidth(), PrintTarget.access$0((PrintTarget)LayerPrinter.access$0(LayerPrinter.this).get(0)).getHeight());
                                            repeatIntersect = printBounds.intersection(repeatIntersect);
                                            this.printLayer((PrintTarget)LayerPrinter.access$0(LayerPrinter.this).get(0), gc, new Rectangle(repeatIntersect.x, 0, repeatIntersect.width, repeatPrintTargetHeight));
                                            printerTransform.translate(0.0f, (float)Math.round(Float.valueOf((float)Math.round(Float.valueOf((float)repeatPrintTargetHeight * repeatScaleFactor[1]).floatValue()) / scaleFactor[1]).floatValue()));
                                        }
                                        if (PrintTarget.access$3(target) != null && verticalPageNumber != 0) {
                                            headerTransform.translate(0.0f, (float)(startY + Math.round(Float.valueOf((float)Math.round(Float.valueOf((float)repeatPrintTargetHeight * (repeatScaleFactor != null ? repeatScaleFactor[1] : 0.0f)).floatValue()) / scaleFactor[1]).floatValue())));
                                            gc.setTransform(headerTransform);
                                            this.printLayer(target, gc, new Rectangle(printBounds.x, 0, intersect.width, headerHeight));
                                            printerTransform.translate(0.0f, (float)headerHeight);
                                        }
                                        if (LayerPrinter.access$10(LayerPrinter.this) && available > 0 && verticalPageNumber == 0) {
                                            printerTransform.translate(0.0f, (float)(printBoundsHeight + headerHeight - availablePixel));
                                        }
                                        gc.setTransform(printerTransform);
                                        this.printLayer(target, gc, intersect);
                                        this.configureScalingTransform(footerTransform, dpiFactor, printerClientArea, footerBounds);
                                        gc.setTransform(footerTransform);
                                        this.printFooter(gc, currentPage, totalPageCount, footerBounds, PrintTarget.access$1(target));
                                        printerTransform.dispose();
                                        repeatTransform.dispose();
                                        headerTransform.dispose();
                                        footerTransform.dispose();
                                    }
                                    ++currentPage;
                                    startX += printBounds.width;
                                    ++horizontalPageNumber;
                                }
                                startY += pbh;
                                available = pageCount[2];
                                prevScaleFactor = scaleFactor;
                                ++verticalPageNumber;
                            }
                            if (LayerPrinter.access$10(LayerPrinter.this) && available > 0) {
                                --currentPage;
                            }
                            if (!LayerPrinter.access$10(LayerPrinter.this) || available < 0) {
                                this.printer.endPage();
                                newPage = true;
                                pageStarted = false;
                            } else if (LayerPrinter.access$10(LayerPrinter.this) && available > 0) {
                                newPage = false;
                                pageStarted = false;
                            }
                        }
                        finally {
                            this.restoreLayerState(target);
                        }
                        if (gridLineWidth[0] != null) continue;
                        PrintTarget.access$1(target).unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH);
                    }
                    if (repeatHeaderGridLineWidth == null) ** break block32
                    if (repeatHeaderGridLineWidth[0] == null) {
                        PrintTarget.access$1((PrintTarget)LayerPrinter.access$0(LayerPrinter.this).get(0)).unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH);
                    }
                    break block33;
                }
                finally {
                    this.printer.endJob();
                    gc.dispose();
                    this.printer.dispose();
                    var45_50 = LayerPrinter.access$0(LayerPrinter.this).iterator();
                    if (true) ** GOTO lbl155
                }
                {
                    block33: {
                    }
                }
                do {
                    target = (PrintTarget)var45_50.next();
                    PrintTarget.access$0(target).doCommand(new TurnViewportOnCommand());
lbl155:
                    // 2 sources

                } while (var45_50.hasNext());
            }
        }

        private void configureScalingTransform(Transform transform, float[] scaleFactor, Rectangle printerClientArea, Rectangle printBounds) {
            transform.scale(scaleFactor[0], scaleFactor[1]);
            transform.translate((float)printerClientArea.x / scaleFactor[0], (float)printerClientArea.y / scaleFactor[1]);
            transform.translate((float)(-1 * printBounds.x), (float)(-1 * printBounds.y));
        }

        private void setLayerSize(PrintTarget target, PrinterData printerData) {
            if (printerData != null && printerData.scope == 2) {
                target.layer.setClientAreaProvider(target.originalClientAreaProvider);
            } else {
                final Rectangle fullLayerSize = LayerPrinter.this.getTotalArea(target.layer);
                target.layer.setClientAreaProvider(new IClientAreaProvider(){

                    @Override
                    public Rectangle getClientArea() {
                        return fullLayerSize;
                    }
                });
                target.layer.doCommand(new PrintEntireGridCommand());
            }
        }

        private void printLayer(PrintTarget target, GC gc, Rectangle printBounds) {
            target.layer.getLayerPainter().paintLayer(target.layer, gc, 0, 0, printBounds, target.configRegistry);
        }

        private void printFooter(GC gc, int currentPage, int totalPageCount, Rectangle printBounds, IConfigRegistry configRegistry) {
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            Font oldFont = gc.getFont();
            Color footerForeground = null;
            Color footerBackground = null;
            Font footerFont = null;
            IStyle style = configRegistry.getConfigAttribute(PrintConfigAttributes.FOOTER_STYLE, "NORMAL", new String[0]);
            if (style != null) {
                footerForeground = style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
                footerBackground = style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
                footerFont = style.getAttributeValue(CellStyleAttributes.FONT);
            }
            gc.setForeground(footerForeground != null ? footerForeground : GUIHelper.COLOR_BLACK);
            gc.setBackground(footerBackground != null ? footerBackground : GUIHelper.COLOR_WHITE);
            gc.setFont(footerFont != null ? footerFont : GUIHelper.DEFAULT_FONT);
            gc.drawLine(printBounds.x, printBounds.y + printBounds.height + 10, printBounds.x + printBounds.width, printBounds.y + printBounds.height + 10);
            gc.drawText(MessageFormat.format(LayerPrinter.this.footerPagePattern, currentPage, totalPageCount), printBounds.x, printBounds.y + printBounds.height + 15);
            gc.drawText(LayerPrinter.this.footerDate, printBounds.x + printBounds.width - gc.textExtent((String)((LayerPrinter)LayerPrinter.this).footerDate).x, printBounds.y + printBounds.height + 15);
            gc.setForeground(oldForeground);
            gc.setBackground(oldBackground);
            gc.setFont(oldFont);
        }

        private void restoreLayerState(PrintTarget target) {
            target.layer.setClientAreaProvider(target.originalClientAreaProvider);
            target.layer.doCommand(new EnableFormulaCachingCommand());
        }
    }

    private class PrintTarget {
        private final IConfigRegistry configRegistry;
        private final ILayer layer;
        private final ILayer repeatHeaderLayer;
        private final IClientAreaProvider originalClientAreaProvider;
        private final boolean repeat;

        PrintTarget(ILayer layer, ILayer repeatHeaderLayer, IConfigRegistry configRegistry, boolean repeat) {
            this.layer = layer;
            this.repeatHeaderLayer = repeatHeaderLayer;
            this.configRegistry = configRegistry;
            this.originalClientAreaProvider = layer.getClientAreaProvider();
            this.repeat = repeat;
        }
    }
}

