/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVoidType;

public class JDIVoidValue
extends JDIValue {
    public JDIVoidValue(JDIDebugTarget target) {
        super(target, target.getVM() != null ? target.getVM().mirrorOfVoid() : null);
    }

    @Override
    protected List<IJavaVariable> getVariablesList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getReferenceTypeName() {
        return "void";
    }

    @Override
    public String getValueString() {
        return "null";
    }

    @Override
    public String getSignature() {
        return "V";
    }

    @Override
    public int getArrayLength() {
        return -1;
    }

    @Override
    public IJavaType getJavaType() {
        return new JDIVoidType((JDIDebugTarget)this.getDebugTarget());
    }

    @Override
    public String toString() {
        return "void";
    }
}

