/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class ProjectManager {
    @Inject
    protected IncrementalBuilder incrementalBuilder;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    protected IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IExternalContentSupport externalContentSupport;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private IndexState indexState = new IndexState();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private URI baseDir;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private Provider<Map<String, ResourceDescriptionsData>> indexProvider;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextResourceSet resourceSet;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private ProjectDescription projectDescription;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IProjectConfig projectConfig;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> acceptor, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider, CancelIndicator cancelIndicator) {
        this.projectDescription = description;
        this.projectConfig = projectConfig;
        this.baseDir = projectConfig.getPath();
        this.issueAcceptor = acceptor;
        this.openedDocumentsContentProvider = openedDocumentsContentProvider;
        this.indexProvider = indexProvider;
    }

    public IncrementalBuilder.Result doInitialBuild(CancelIndicator cancelIndicator) {
        ArrayList uris = CollectionLiterals.newArrayList();
        Consumer<ISourceFolder> _function = it -> {
            IAcceptor _function_1 = it_1 -> uris.add(it_1);
            this.fileSystemScanner.scan(it.getPath(), _function_1);
        };
        this.projectConfig.getSourceFolders().forEach(_function);
        return this.doBuild(uris, CollectionLiterals.emptyList(), CollectionLiterals.emptyList(), cancelIndicator);
    }

    public IncrementalBuilder.Result doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        BuildRequest request = this.newBuildRequest(dirtyFiles, deletedFiles, externalDeltas, cancelIndicator);
        Functions.Function1 _function = it -> this.languagesRegistry.getResourceServiceProvider(it);
        IncrementalBuilder.Result result = this.incrementalBuilder.build(request, _function);
        this.indexState = result.getIndexState();
        this.resourceSet = request.getResourceSet();
        ((Map)this.indexProvider.get()).put(this.projectDescription.getName(), this.indexState.getResourceDescriptions());
        return result;
    }

    protected BuildRequest newBuildRequest(List<URI> changedFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        BuildRequest _buildRequest = new BuildRequest();
        Procedures.Procedure1 _function = it -> {
            it.setBaseDir(this.baseDir);
            ResourceDescriptionsData _copy = this.indexState.getResourceDescriptions().copy();
            Source2GeneratedMapping _copy_1 = this.indexState.getFileMappings().copy();
            IndexState _indexState = new IndexState(_copy, _copy_1);
            it.setState(_indexState);
            it.setResourceSet(this.createFreshResourceSet(it.getState().getResourceDescriptions()));
            it.setDirtyFiles(changedFiles);
            it.setDeletedFiles(deletedFiles);
            it.setExternalDeltas(externalDeltas);
            BuildRequest.IPostValidationCallback _function_1 = (uri, issues) -> {
                this.issueAcceptor.apply((Object)uri, (Object)issues);
                return true;
            };
            it.setAfterValidate(_function_1);
            it.setCancelIndicator(cancelIndicator);
        };
        return (BuildRequest)ObjectExtensions.operator_doubleArrow((Object)_buildRequest, (Procedures.Procedure1)_function);
    }

    public XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet _get = (XtextResourceSet)this.resourceSetProvider.get();
        Procedures.Procedure1 _function = it -> {
            this.projectDescription.attachToEmfObject((Notifier)it);
            ProjectConfigAdapter.install((ResourceSet)it, (IProjectConfig)this.projectConfig);
            Map _get_1 = (Map)this.indexProvider.get();
            ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(_get_1, (ResourceSet)it);
            index.setContainer(this.projectDescription.getName(), newIndex);
            this.externalContentSupport.configureResourceSet((ResourceSet)it, this.openedDocumentsContentProvider);
        };
        return (XtextResourceSet)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        if (this.resourceSet == null) {
            this.resourceSet = this.createNewResourceSet(newIndex);
        } else {
            ChunkedResourceDescriptions resDescs = ChunkedResourceDescriptions.findInEmfObject((Notifier)this.resourceSet);
            Set _entrySet = ((Map)this.indexProvider.get()).entrySet();
            for (Map.Entry entry : _entrySet) {
                resDescs.setContainer((String)entry.getKey(), (ResourceDescriptionsData)entry.getValue());
            }
            resDescs.setContainer(this.projectDescription.getName(), newIndex);
        }
        return this.resourceSet;
    }

    public Resource getResource(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        resource.getContents();
        return resource;
    }

    public void reportProjectIssue(String message, String code, Severity severity) {
        Issue.IssueImpl _issueImpl = new Issue.IssueImpl();
        Procedures.Procedure1 _function = it -> {
            it.setMessage(message);
            it.setCode(code);
            it.setSeverity(severity);
            it.setUriToProblem(this.baseDir);
        };
        Issue.IssueImpl _doubleArrow = (Issue.IssueImpl)ObjectExtensions.operator_doubleArrow((Object)_issueImpl, (Procedures.Procedure1)_function);
        this.issueAcceptor.apply((Object)this.baseDir, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Issue[]{_doubleArrow})));
    }

    @Pure
    public IndexState getIndexState() {
        return this.indexState;
    }

    protected void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    @Pure
    public URI getBaseDir() {
        return this.baseDir;
    }

    @Pure
    protected Procedures.Procedure2<? super URI, ? super Iterable<Issue>> getIssueAcceptor() {
        return this.issueAcceptor;
    }

    @Pure
    protected Provider<Map<String, ResourceDescriptionsData>> getIndexProvider() {
        return this.indexProvider;
    }

    @Pure
    protected IExternalContentSupport.IExternalContentProvider getOpenedDocumentsContentProvider() {
        return this.openedDocumentsContentProvider;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public ProjectDescription getProjectDescription() {
        return this.projectDescription;
    }

    @Pure
    public IProjectConfig getProjectConfig() {
        return this.projectConfig;
    }
}

