/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public interface IRenameStrategy2 {
    public void applyRename(RenameContext var1);

    public static class DefaultImpl
    implements IRenameStrategy2 {
        @Inject
        private IResourceServiceProvider resourceServiceProvider;

        public boolean canHandle(RenameChange change) {
            return this.resourceServiceProvider.canHandle(change.getTargetURI());
        }

        @Override
        public void applyRename(RenameContext context) {
            Functions.Function1 _function = it -> this.canHandle((RenameChange)it);
            Consumer<RenameChange> _function_1 = change -> {
                IChangeSerializer.IModification<EObject> _function_2 = it -> this.doRename((EObject)it, (RenameChange)change, context);
                context.addModification((RenameChange)change, _function_2);
            };
            IterableExtensions.filter(context.getChanges(), (Functions.Function1)_function).forEach(_function_1);
        }

        protected void doRename(EObject target, RenameChange change, RenameContext context) {
            EAttribute nameAttribute = this.getNameEAttribute(target);
            if (nameAttribute != null) {
                target.eSet((EStructuralFeature)nameAttribute, (Object)change.getNewName());
            } else {
                String _name = target.eClass().getName();
                String _plus = "Element of class " + _name;
                String _plus_1 = _plus + " cannot be renamed.";
                context.getIssues().add(RefactoringIssueAcceptor.Severity.WARNING, _plus_1, new Object[0]);
            }
        }

        protected EAttribute getNameEAttribute(EObject target) {
            Functions.Function1 _function = it -> Objects.equal((Object)it.getName(), (Object)"name") && Objects.equal((Object)it.getEType(), (Object)EcorePackage.Literals.ESTRING);
            return (EAttribute)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)target.eClass().getEAllAttributes(), (Functions.Function1)_function));
        }
    }
}

