/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.preferences.AutomatedModelCompletionPreferenceDescriptor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractAutomatedModelCompletionPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String FIRST_COLUMN_NAME = Messages.AbstractAutomatedModelCompletionPreferencesPage_Elements;
    static final String SECOND_COLUMN_NAME = Messages.AbstractAutomatedModelCompletionPreferencesPage_Accelerators;
    static final int ROW_HEIGHT = 25;
    private HashMap<AutomatedModelCompletionPreferenceDescriptor, Combo> mapInstanceComboBox;
    protected List<AutomatedModelCompletionPreferenceDescriptor> automatedModelCompletionDescriptorsList = new ArrayList<AutomatedModelCompletionPreferenceDescriptor>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void performApply() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<AutomatedModelCompletionPreferenceDescriptor, Combo> entry : this.mapInstanceComboBox.entrySet()) {
            String value = entry.getValue().getText();
            store.setValue(entry.getKey().getPreferenceConstant(), value);
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<AutomatedModelCompletionPreferenceDescriptor, Combo> entry : this.mapInstanceComboBox.entrySet()) {
            String selected = preferences.getDefaultString(entry.getKey().getPreferenceConstant());
            entry.getValue().setText(selected);
        }
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new GridLayout(1, true));
        self.setLayoutData((Object)new GridData(1808));
        TableViewer tableViewer = new TableViewer(self, 2048);
        Table table = tableViewer.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        tableViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() != 0) {
                    return;
                }
                super.update(cell);
            }

            public String getText(Object element) {
                if (element instanceof AutomatedModelCompletionPreferenceDescriptor) {
                    String text = ((AutomatedModelCompletionPreferenceDescriptor)element).getElement().toString();
                    text = text.replaceAll("org.eclipse.uml2.uml.", "");
                    text = text.replaceFirst("interface\\s", "");
                    return text;
                }
                return super.getText(element);
            }
        });
        TableLayout layout = new TableLayout();
        new TableColumn(table, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, true));
        new TableColumn(table, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, true));
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getColumn(0).setText(FIRST_COLUMN_NAME);
        table.getColumn(1).setText(SECOND_COLUMN_NAME);
        tableViewer.setInput(this.automatedModelCompletionDescriptorsList);
        this.mapInstanceComboBox = new HashMap();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() instanceof AutomatedModelCompletionPreferenceDescriptor) {
                TableEditor editor = new TableEditor(table);
                Combo comboBox = new Combo((Composite)table, 4);
                List<String> list = ((AutomatedModelCompletionPreferenceDescriptor)item.getData()).getListOfAccelerator();
                Collections.sort(list);
                for (String updater : list) {
                    comboBox.add(updater);
                }
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                comboBox.setText(store.getString(((AutomatedModelCompletionPreferenceDescriptor)item.getData()).getPreferenceConstant()));
                TableItem currentItem = item;
                AutomatedModelCompletionPreferenceDescriptor strategy = (AutomatedModelCompletionPreferenceDescriptor)currentItem.getData();
                this.mapInstanceComboBox.put(strategy, comboBox);
                editor.setEditor((Control)comboBox, item, 1);
                editor.horizontalAlignment = 0x1000000;
                editor.grabHorizontal = true;
            }
            ++n2;
        }
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        return self;
    }
}

