/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.ui.text.Chain;
import org.eclipse.jdt.internal.ui.text.ChainElement;
import org.eclipse.jdt.internal.ui.text.TypeBindingAnalyzer;

public class ChainFinder {
    private final List<ITypeBinding> expectedTypes;
    private final List<String> excludedTypes;
    private final IJavaElement invocationSite;
    private final List<Chain> chains = new LinkedList<Chain>();
    private final Map<IBinding, ChainElement> edgeCache = new HashMap<IBinding, ChainElement>();
    private final Map<Map<ITypeBinding, Boolean>, List<IBinding>> fieldsAndMethodsCache = new HashMap<Map<ITypeBinding, Boolean>, List<IBinding>>();
    private final Map<Map<ChainElement, ITypeBinding>, Boolean> assignableCache = new HashMap<Map<ChainElement, ITypeBinding>, Boolean>();

    public ChainFinder(List<ITypeBinding> expectedTypes, List<String> excludedTypes, IJavaElement invocationSite) {
        this.expectedTypes = expectedTypes;
        this.excludedTypes = excludedTypes;
        this.invocationSite = invocationSite;
    }

    public void startChainSearch(List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        for (ITypeBinding expected : this.expectedTypes) {
            if (expected == null || ChainFinder.isFromExcludedType(this.excludedTypes, (IBinding)expected)) continue;
            ITypeBinding expectedType = expected;
            int expectedDimension = 0;
            if (expectedType.isArray()) {
                expectedDimension = expectedType.getDimensions();
                expectedType = TypeBindingAnalyzer.removeArrayWrapper(expectedType);
            }
            this.searchChainsForExpectedType(expectedType, expectedDimension, entrypoints, maxChains, minDepth, maxDepth);
        }
    }

    private void searchChainsForExpectedType(ITypeBinding expectedType, int expectedDimensions, List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        LinkedList<LinkedList<ChainElement>> incompleteChains = ChainFinder.prepareQueue(entrypoints);
        while (!incompleteChains.isEmpty()) {
            LinkedList<ChainElement> chain = incompleteChains.poll();
            ChainElement edge = chain.getLast();
            if (this.isValidEndOfChain(edge, expectedType, expectedDimensions)) {
                if (chain.size() < minDepth) continue;
                this.chains.add(new Chain(chain, expectedDimensions));
                if (this.chains.size() != maxChains) continue;
                break;
            }
            if (chain.size() >= maxDepth || incompleteChains.size() > 50000) continue;
            this.searchDeeper(chain, incompleteChains, edge.getReturnType());
        }
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    private static LinkedList<LinkedList<ChainElement>> prepareQueue(List<ChainElement> entrypoints) {
        LinkedList<LinkedList<ChainElement>> incompleteChains = new LinkedList<LinkedList<ChainElement>>();
        for (ChainElement entrypoint : entrypoints) {
            LinkedList<ChainElement> chain = new LinkedList<ChainElement>();
            chain.add(entrypoint);
            incompleteChains.add(chain);
        }
        return incompleteChains;
    }

    public static boolean isFromExcludedType(List<String> excluded, IBinding binding) {
        String tmp = String.valueOf(binding.getKey());
        int index = tmp.indexOf(";");
        String key = index == -1 ? tmp : tmp.substring(0, index);
        return excluded.contains(key);
    }

    private boolean isValidEndOfChain(ChainElement edge, ITypeBinding expectedType, int expectedDimension) {
        if (edge.getElementBinding().getKind() == 2) {
            return false;
        }
        Boolean isAssignable = this.assignableCache.get(Collections.singletonMap(edge, expectedType));
        if (isAssignable == null) {
            isAssignable = TypeBindingAnalyzer.isAssignable(edge, expectedType, expectedDimension);
            this.assignableCache.put(Collections.singletonMap(edge, expectedType), isAssignable);
        }
        return isAssignable;
    }

    private void searchDeeper(LinkedList<ChainElement> chain, List<LinkedList<ChainElement>> incompleteChains, ITypeBinding currentlyVisitedType) {
        boolean staticOnly = false;
        if (chain.getLast().getElementBinding().getKind() == 2) {
            staticOnly = true;
        }
        for (IBinding element : this.findAllFieldsAndMethods(currentlyVisitedType, staticOnly)) {
            ChainElement newEdge = this.createEdge(element);
            if (chain.contains(newEdge)) continue;
            incompleteChains.add(ChainFinder.cloneChainAndAppendEdge(chain, newEdge));
        }
    }

    private List<IBinding> findAllFieldsAndMethods(ITypeBinding chainElementType, boolean staticOnly) {
        List<IBinding> cached = this.fieldsAndMethodsCache.get(Collections.singletonMap(chainElementType, staticOnly));
        if (cached == null) {
            cached = new LinkedList<IBinding>();
            Collection<IBinding> candidates = staticOnly ? TypeBindingAnalyzer.findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(chainElementType, this.invocationSite) : TypeBindingAnalyzer.findVisibleInstanceFieldsAndRelevantInstanceMethods(chainElementType, this.invocationSite);
            for (IBinding binding : candidates) {
                if (ChainFinder.isFromExcludedType(this.excludedTypes, binding)) continue;
                cached.add(binding);
            }
            this.fieldsAndMethodsCache.put(Collections.singletonMap(chainElementType, staticOnly), cached);
        }
        return cached;
    }

    private ChainElement createEdge(IBinding member) {
        ChainElement cached = this.edgeCache.get(member);
        if (cached == null) {
            cached = new ChainElement(member, false);
            this.edgeCache.put(member, cached);
        }
        return cached;
    }

    private static LinkedList<ChainElement> cloneChainAndAppendEdge(LinkedList<ChainElement> chain, ChainElement newEdge) {
        LinkedList chainCopy = (LinkedList)chain.clone();
        chainCopy.add(newEdge);
        return chainCopy;
    }
}

