/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.preferences.PapyrusScopedPreferenceStore;
import org.eclipse.papyrus.infra.ui.preferences.dialog.AbstractApplyValueOnPreferenceKeyDialog;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractPapyrusPreferenceStore
extends PapyrusScopedPreferenceStore {
    private final String elementLevelPrefix;
    private final String instanceEditorLevelPrefix;
    private final String editorLevelPrefix;

    public AbstractPapyrusPreferenceStore(IScopeContext context, String qualifier, String editorLevelPrefix, String instanceEditorLevelPrefix, String elementLevelPrefix) {
        super(context, qualifier);
        this.editorLevelPrefix = editorLevelPrefix;
        this.instanceEditorLevelPrefix = instanceEditorLevelPrefix;
        this.elementLevelPrefix = elementLevelPrefix;
    }

    public AbstractPapyrusPreferenceStore(IScopeContext context, String qualifier, String defaultQualifierPath, String editorLevelPrefix, String instanceEditorLevelPrefix, String elementLevelPrefix) {
        super(context, qualifier, defaultQualifierPath);
        this.editorLevelPrefix = editorLevelPrefix;
        this.instanceEditorLevelPrefix = instanceEditorLevelPrefix;
        this.elementLevelPrefix = elementLevelPrefix;
    }

    public void deleteAllSubPreference(String level) {
        ArrayList<String> elementKey = new ArrayList<String>();
        try {
            int i = 0;
            while (i < this.getStorePreferences().keys().length) {
                if (level.startsWith(this.instanceEditorLevelPrefix)) {
                    if (this.getStorePreferences().keys()[i].startsWith(this.elementLevelPrefix)) {
                        elementKey.add(this.getStorePreferences().keys()[i]);
                    }
                } else if (level.startsWith(this.editorLevelPrefix) && (this.getStorePreferences().keys()[i].startsWith(this.elementLevelPrefix) || this.getStorePreferences().keys()[i].startsWith(this.instanceEditorLevelPrefix))) {
                    elementKey.add(this.getStorePreferences().keys()[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (elementKey.size() > 0) {
            ArrayList<Object> keytoRemove = new ArrayList();
            String[] keyRoconsult = new String[elementKey.size()];
            AbstractApplyValueOnPreferenceKeyDialog dialog = this.createPreferenceKeyDialog(elementKey.toArray(keyRoconsult));
            dialog.open();
            keytoRemove = dialog.getKeyToRemove();
            for (String string : keytoRemove) {
                this.getStorePreferences().remove(string);
            }
        }
    }

    protected abstract AbstractApplyValueOnPreferenceKeyDialog createPreferenceKeyDialog(String[] var1);

    protected String findKeyWithAValue(String initialKey) {
        String foundedKey = null;
        foundedKey = this.findKeyAStoreValue(initialKey);
        if (foundedKey == null) {
            foundedKey = this.findKeyWithADefaultValue(initialKey);
        }
        if (foundedKey == null) {
            foundedKey = initialKey;
        }
        return foundedKey;
    }

    protected String findKeyAStoreValue(String initialKey) {
        String foundedKey = null;
        if (this.getStorePreferences().get(initialKey, null) != null) {
            foundedKey = initialKey;
        }
        if (foundedKey == null && this.hasPrefix(initialKey)) {
            foundedKey = this.findKeyAStoreValue(this.getUpperKey(initialKey));
        }
        return foundedKey;
    }

    protected String findKeyWithADefaultValue(String initialKey) {
        String foundedKey = null;
        if (this.getDefaultPreferences().get(initialKey, null) != null) {
            foundedKey = initialKey;
        }
        if (foundedKey == null && this.hasPrefix(initialKey)) {
            return this.findKeyWithADefaultValue(this.getUpperKey(initialKey));
        }
        foundedKey = initialKey;
        return foundedKey;
    }

    protected String getUpperKey(String initialKey) {
        String out = initialKey.toString();
        if (initialKey.startsWith(this.elementLevelPrefix)) {
            out = initialKey.toString().replaceAll(this.elementLevelPrefix, this.instanceEditorLevelPrefix);
            out = String.valueOf(out.substring(0, out.lastIndexOf("_"))) + out.substring(out.indexOf("."), out.length());
        }
        if (initialKey.startsWith(this.instanceEditorLevelPrefix)) {
            out = String.valueOf(this.editorLevelPrefix) + out.substring(out.indexOf("."), out.length());
        }
        return out;
    }

    protected boolean hasPrefix(String key) {
        return key.startsWith(this.elementLevelPrefix) || key.startsWith(this.instanceEditorLevelPrefix);
    }

    @Override
    protected String internalGet(String key) {
        String newKey = this.findKeyWithAValue(key);
        return Platform.getPreferencesService().get(newKey, null, (Preferences[])this.getPreferenceNodes(true));
    }

    @Override
    public boolean getDefaultBoolean(String name) {
        return super.getDefaultBoolean(this.findKeyWithADefaultValue(name));
    }

    @Override
    public double getDefaultDouble(String name) {
        return super.getDefaultDouble(this.findKeyWithADefaultValue(name));
    }

    @Override
    public float getDefaultFloat(String name) {
        return super.getDefaultFloat(this.findKeyWithADefaultValue(name));
    }

    @Override
    public int getDefaultInt(String name) {
        return super.getDefaultInt(this.findKeyWithADefaultValue(name));
    }

    @Override
    public long getDefaultLong(String name) {
        return super.getDefaultLong(this.findKeyWithADefaultValue(name));
    }

    @Override
    public String getDefaultString(String name) {
        return super.getDefaultString(this.findKeyWithADefaultValue(name));
    }
}

