/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractPapyrusHandler
extends AbstractHandler {
    protected TransactionalEditingDomain getEditingDomain(ExecutionEvent execution) {
        TransactionalEditingDomain result = null;
        try {
            result = ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain(execution);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    protected TransactionalEditingDomain getEditingDomain(IEvaluationContext context) {
        TransactionalEditingDomain result = null;
        try {
            result = ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain(context);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    protected IPageManager getPageManager(ExecutionEvent execution) {
        IPageManager result = null;
        try {
            result = ServiceUtilsForHandlers.getInstance().getIPageManager(execution);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    protected IPageManager getPageManager(IEvaluationContext context) {
        IPageManager result = null;
        try {
            result = ServiceUtilsForIEvaluationContext.getInstance().getIPageManager(context);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    private <T> T adapt(Object object, Class<T> expectedClassType) {
        EObject eobject = EMFHelper.getEObject((Object)object);
        if (eobject != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        Object ele = Platform.getAdapterManager().getAdapter(object, expectedClassType);
        if (ele != null) {
            return (T)ele;
        }
        if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class)) != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        return null;
    }

    private <T> List<T> getAllElementAdaptedToType(List<Object> list, Class<T> expectedClassType) {
        ArrayList<T> res = new ArrayList<T>();
        for (Object cur : list) {
            T adapted = this.adapt(cur, expectedClassType);
            if (adapted == null) continue;
            res.add(adapted);
        }
        return res;
    }

    protected <T> List<T> getCurrentSelectionAdaptedToType(ExecutionEvent event, Class<T> expectedType) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return this.getAllElementAdaptedToType(structuredSelection.toList(), expectedType);
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return this.getAllElementAdaptedToType(treeSelection.toList(), expectedType);
        }
        return null;
    }
}

