/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.IPageUtils;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.editor.welcome.IWelcomePageService;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractWelcomePageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor multiEditor = (IMultiDiagramEditor)editor;
            try {
                IWelcomePageService welcomeService = (IWelcomePageService)multiEditor.getServicesRegistry().getService(IWelcomePageService.class);
                this.doExecute(multiEditor, welcomeService);
            }
            catch (ServiceException e) {
                throw new ExecutionException("Could not obtain the welcome-page service.", (Throwable)e);
            }
        }
        return null;
    }

    protected abstract void doExecute(IMultiDiagramEditor var1, IWelcomePageService var2);

    public void setEnabled(Object evaluationContext) {
        IMultiDiagramEditor multiEditor;
        ISashWindowsContainer sashContainer;
        boolean enable = false;
        Object editor = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (editor instanceof IMultiDiagramEditor && (sashContainer = (ISashWindowsContainer)(multiEditor = (IMultiDiagramEditor)editor).getAdapter(ISashWindowsContainer.class)) != null && !sashContainer.isDisposed()) {
            IPage activePage = sashContainer.getActiveSashWindowsPage();
            try {
                IWelcomePageService welcomeService = (IWelcomePageService)multiEditor.getServicesRegistry().getService(IWelcomePageService.class);
                enable = this.isEnabled(multiEditor, activePage, welcomeService);
            }
            catch (ServiceException e) {
                Activator.log.error("Could not obtain the welcome-page service.", (Throwable)e);
            }
        }
        this.setBaseEnabled(enable);
    }

    protected boolean isEnabled(IMultiDiagramEditor editor, IPage activePage, IWelcomePageService welcomeService) {
        return activePage != null && IPageUtils.getRawModel((IPage)activePage) == welcomeService.getWelcome();
    }
}

