/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.command.ConfigureMessageEventCommand;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageHelperAdvice
extends AbstractEditHelperAdvice {
    protected Element getSource(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected Element getTarget(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected boolean isValidConfigureRequest(ConfigureRequest request) {
        ConfigureRequest req = request;
        boolean valid = true;
        if (this.getSource(req) == null || this.getTarget(req) == null) {
            valid = false;
        } else if (!(this.getSource(req) instanceof Lifeline || this.getSource(req) instanceof Interaction || this.getSource(req) instanceof Gate || this.getSource(req) instanceof ExecutionSpecification)) {
            valid = false;
        } else if (!(this.getTarget(req) instanceof Lifeline || this.getTarget(req) instanceof Interaction || this.getTarget(req) instanceof Gate || this.getTarget(req) instanceof ExecutionSpecification)) {
            valid = false;
        }
        return valid;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        Element source = this.getSource(request);
        Element target = this.getTarget(request);
        UnexecutableCommand beforeConfigCommand = null;
        if (!this.isValidConfigureRequest(request)) {
            beforeConfigCommand = UnexecutableCommand.INSTANCE;
        } else {
            ICommand setTargetEndCommand;
            ICommand setSourceEndCommand;
            ICommand configureMessageCommand = this.getConfigureCommand(request);
            CompositeCommand command = new CompositeCommand(configureMessageCommand.getLabel());
            if (configureMessageCommand != null) {
                command.compose((IUndoableOperation)configureMessageCommand);
            }
            if (source instanceof MessageEnd && (setSourceEndCommand = this.getSetMessageEndCommand((MessageEnd)source, request)) != null && setSourceEndCommand.canExecute()) {
                command.compose((IUndoableOperation)setSourceEndCommand);
            }
            if (target instanceof MessageEnd && (setTargetEndCommand = this.getSetMessageEndCommand((MessageEnd)target, request)) != null && setTargetEndCommand.canExecute()) {
                command.compose((IUndoableOperation)setTargetEndCommand);
            }
            if (!command.isEmpty()) {
                beforeConfigCommand = command;
            }
        }
        return beforeConfigCommand;
    }

    protected ICommand getSetMessageEndCommand(MessageEnd msgEnd, ConfigureRequest request) {
        ICommand semanticCommand = null;
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((EObject)msgEnd);
        SetRequest setMsgEndRequest = new SetRequest((EObject)msgEnd, (EStructuralFeature)UMLPackage.eINSTANCE.getMessageEnd_Message(), (Object)request.getElementToConfigure());
        if (commandService != null) {
            semanticCommand = commandService.getEditCommand((IEditCommandRequest)setMsgEndRequest);
        }
        return semanticCommand;
    }

    protected ICommand getConfigureCommand(ConfigureRequest request) {
        return new ConfigureMessageEventCommand(request);
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        MessageEnd recvEvent;
        ArrayList<MessageEnd> dependentsToDestroy = new ArrayList<MessageEnd>();
        Message message = (Message)request.getElementToDestroy();
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent != null && !MessageHelperAdvice.isSharedEvent(sendEvent, (EObject)message)) {
            dependentsToDestroy.add(sendEvent);
        }
        if ((recvEvent = message.getReceiveEvent()) != null && !MessageHelperAdvice.isSharedEvent(recvEvent, (EObject)message)) {
            dependentsToDestroy.add(recvEvent);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    public static boolean isSharedEvent(MessageEnd usedObject, EObject knownReferencer) {
        EPackage mmPackage = usedObject.eClass().getEPackage();
        HashSet<EObject> crossReferences = new HashSet<EObject>();
        for (EStructuralFeature.Setting setting : EMFHelper.getUsages((EObject)usedObject)) {
            EObject eObj = setting.getEObject();
            if (setting.getEStructuralFeature().equals(UMLPackage.eINSTANCE.getLifeline_CoveredBy()) || !eObj.eClass().getEPackage().equals(mmPackage)) continue;
            crossReferences.add(eObj);
        }
        crossReferences.remove(usedObject.eContainer());
        crossReferences.remove(knownReferencer);
        return !crossReferences.isEmpty();
    }

    @Deprecated
    public static MessageEnd createMessageEnd(Message message, Lifeline lifeline, MessageEnd previous) {
        MessageOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        if (previous == null) {
            messageOccurrenceSpecification.setCovered(lifeline);
        } else {
            lifeline.getCoveredBys().add(lifeline.getCoveredBys().indexOf((Object)previous) + 1, (Object)messageOccurrenceSpecification);
        }
        messageOccurrenceSpecification.setMessage(message);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    @Deprecated
    public static MessageEnd createDestroyMessageEnd(Message message, Lifeline lifeline) {
        DestructionOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification();
        messageOccurrenceSpecification.setCovered(lifeline);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }
}

