/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.commands;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.decoratormodel.internal.messages.Messages;

public class SaveDecoratorModelCommand
extends AbstractCommand
implements AbstractCommand.NonDirtying {
    private final ModelSet modelSet;
    private final URI resourceURIWithoutExtension;
    private Set<URI> rescued;

    public SaveDecoratorModelCommand(ModelSet modelSet, URI resourceURI) {
        super(Messages.SaveDecoratorModelCommand_0);
        this.modelSet = modelSet;
        this.resourceURIWithoutExtension = resourceURI.trimFileExtension();
    }

    protected boolean prepare() {
        this.rescued = Sets.newHashSet();
        for (URI next : this.modelSet.getResourcesToDeleteOnSave()) {
            if (!next.trimFileExtension().equals(this.resourceURIWithoutExtension)) continue;
            this.rescued.add(next);
        }
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.modelSet.getResourcesToDeleteOnSave().removeAll(this.rescued);
    }

    public void undo() {
        this.modelSet.getResourcesToDeleteOnSave().addAll(this.rescued);
    }

    public void redo() {
        this.execute();
    }
}

