/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.commands;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.decoratormodel.internal.messages.Messages;

public class DeleteDecoratorModelCommand
extends AbstractCommand
implements AbstractCommand.NonDirtying {
    private final ModelSet modelSet;
    private final Resource resource;
    private Collection<Resource> deleted;

    public DeleteDecoratorModelCommand(ModelSet modelSet, Resource resource) {
        super(Messages.DeleteDecoratorModelCommand_0);
        this.modelSet = modelSet;
        this.resource = resource;
    }

    protected boolean prepare() {
        return this.resource != null && this.resource.isLoaded();
    }

    public void execute() {
        if (this.resource.getContents().isEmpty()) {
            this.deleted = Lists.newArrayListWithExpectedSize((int)3);
            this.modelSet.getResourcesToDeleteOnSave().add(this.resource.getURI());
            this.resource.unload();
            this.modelSet.getResources().remove((Object)this.resource);
            this.resource.eAdapters().clear();
            this.deleted.add(this.resource);
            URI withoutExtension = this.resource.getURI().trimFileExtension();
            Iterator iter = this.modelSet.getResources().iterator();
            while (iter.hasNext()) {
                Resource next = (Resource)iter.next();
                if (!next.getURI().trimFileExtension().equals(withoutExtension)) continue;
                this.modelSet.getResourcesToDeleteOnSave().add(next.getURI());
                next.unload();
                iter.remove();
                next.eAdapters().clear();
                this.deleted.add(next);
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.deleted != null) {
            for (Resource next : this.deleted) {
                this.modelSet.getResourcesToDeleteOnSave().remove(next.getURI());
                if (this.modelSet.getResource(next.getURI(), false) != null) continue;
                this.modelSet.getResources().add((Object)next);
            }
        }
    }

    public void redo() {
        this.execute();
    }
}

