/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;

public class LabelAlignmentEditPolicy
extends AbstractEditPolicy {
    public static final String LABEL_ALIGNMENT_KEY = "Label Alignment";
    private int alignment;
    private GraphicalEditPart label;
    private Rectangle refBounds;
    private Rectangle bounds;

    public Command getCommand(Request request) {
        Command cmd = null;
        if ("align".equals(request.getType())) {
            cmd = this.getAlignLabelCommand((AlignmentRequest)request);
        }
        return cmd;
    }

    private Command getAlignLabelCommand(AlignmentRequest request) {
        this.alignment = request.getAlignment();
        this.refBounds = request.getAlignmentRectangle().getCopy();
        this.label = (GraphicalEditPart)this.getHost();
        this.bounds = LabelAlignmentEditPolicy.getAbsolutePosition((EditPart)this.label);
        Point moveDelta = new Point(0, 0);
        if (this.isAlignmentAllowed()) {
            switch (this.alignment) {
                case 1: {
                    moveDelta.setX(this.refBounds.x - this.bounds.x);
                    break;
                }
                case 4: {
                    moveDelta.setX(this.refBounds.getRight().x - this.bounds.getRight().x);
                    break;
                }
                case 8: {
                    moveDelta.setY(this.refBounds.y - this.bounds.y);
                    break;
                }
                case 32: {
                    moveDelta.setY(this.refBounds.getBottom().y - this.bounds.getBottom().y);
                    break;
                }
                case 2: {
                    moveDelta.setX(this.refBounds.getTop().x - this.bounds.getTop().x);
                    break;
                }
                case 16: {
                    moveDelta.setY(this.refBounds.getLeft().y - this.bounds.getLeft().y);
                }
            }
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
            req.setEditParts(request.getEditParts());
            req.setMoveDelta(moveDelta);
            req.setExtendedData(request.getExtendedData());
            return this.getHost().getCommand((Request)req);
        }
        return null;
    }

    private boolean isAlignmentAllowed() {
        EditPart parent = this.label.getParent();
        boolean isAllow = true;
        if (parent instanceof AbstractConnectionEditPart) {
            int sourceSelectionType = ((ConnectionEditPart)this.label.getParent()).getSource().getSelected();
            int targetSelectionType = ((ConnectionEditPart)this.label.getParent()).getTarget().getSelected();
            boolean isRefDependent = this.isRefSibling(parent);
            if (!isRefDependent) {
                boolean isExtremitiesSelected = sourceSelectionType == 1 || targetSelectionType == 1;
                isAllow = !isExtremitiesSelected;
            }
        } else if (parent instanceof AbstractBorderItemEditPart) {
            isAllow = parent.getSelected() != 1;
        }
        return isAllow;
    }

    private boolean isRefSibling(EditPart parent) {
        boolean isRefSibling = false;
        if (parent instanceof AbstractConnectionEditPart) {
            List children = parent.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext() && !isRefSibling) {
                Object child = iter.next();
                if (((EditPart)child).getSelected() != 2) continue;
                isRefSibling = true;
            }
        }
        return isRefSibling;
    }

    public static Rectangle getAbsolutePosition(EditPart ep) {
        GraphicalEditPart part = (GraphicalEditPart)ep;
        Rectangle rect = part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }
}

