/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.decoration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class ConnectionDecorationRegistry {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.common.connectionDecoration";
    private static volatile ConnectionDecorationRegistry registry;
    protected Map<String, Class<? extends RotatableDecoration>> decorationMap = null;
    protected Map<String, String> labelMap = null;

    private ConnectionDecorationRegistry() {
    }

    public static synchronized ConnectionDecorationRegistry getInstance() {
        if (registry == null) {
            registry = new ConnectionDecorationRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.decorationMap = new HashMap<String, Class<? extends RotatableDecoration>>();
        this.labelMap = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String decorationlabel;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String decorationName = element.getAttribute("name");
            String decorationClass = element.getAttribute("class");
            Class loadClass = ClassLoaderHelper.loadClass((String)decorationClass, RotatableDecoration.class);
            if (loadClass != null) {
                this.decorationMap.put(decorationName, loadClass);
            }
            if ((decorationlabel = element.getAttribute("label")) != null) {
                this.labelMap.put(decorationName, decorationlabel);
            }
            ++n2;
        }
    }

    public Class<? extends RotatableDecoration> getDecorationClass(String decorationName) {
        Class<? extends RotatableDecoration> decorationClass = null;
        if (decorationName != null) {
            decorationClass = this.decorationMap.get(decorationName);
        }
        return decorationClass;
    }

    public Map<String, Class<? extends RotatableDecoration>> getAvailableDecoration() {
        return this.decorationMap;
    }

    public String getLabel(String decorationName) {
        return this.labelMap.get(decorationName);
    }

    public String getName(String decorationLabel) {
        String name = null;
        try {
            name = (String)this.labelMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(decorationLabel)).findFirst().get().getKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }
}

