/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CreateEditBasedElementCommand
extends CreateElementCommand {
    private EObject elementToEdit;
    protected EObject newElement;
    protected CompositeEMFOperation compositeEMFOperation;
    public static final String ECLASS_HINT = "ECLASS_HINT";
    protected EClass eClassHint = null;

    public CreateEditBasedElementCommand(CreateElementRequest request) {
        super(request);
        EObject container;
        Object eClassHintParamValue = request.getParameter(ECLASS_HINT);
        if (eClassHintParamValue instanceof EClass) {
            this.eClassHint = (EClass)eClassHintParamValue;
        }
        if ((container = request.getContainer()) != null && container.eClass().getEAllContainments().contains((Object)request.getContainmentFeature())) {
            this.setElementToEdit(container);
        }
    }

    public boolean canExecute() {
        return super.canExecute() && this.prepareOperation().canExecute();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IUndoableOperation operation = this.prepareOperation();
        IStatus compositeStatus = operation.execute(monitor, info);
        return compositeStatus == null ? CommandResult.newOKCommandResult((Object)this.newElement) : new CommandResult(compositeStatus, (Object)this.newElement);
    }

    protected IUndoableOperation prepareOperation() {
        if (this.compositeEMFOperation == null) {
            this.compositeEMFOperation = new CompositeEMFOperation(this.getEditingDomain(), "Create Element");
            CreateEditBasedElementTransactionalCommand createTransactionalCommand = new CreateEditBasedElementTransactionalCommand(this.getEditingDomain(), "Create basic element", this.getAffectedFiles());
            this.compositeEMFOperation.add((IUndoableOperation)createTransactionalCommand);
            AbstractTransactionalCommand configureTransactionalCommand = new AbstractTransactionalCommand(this.getEditingDomain(), "Configure element", this.getAffectedFiles()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ConfigureRequest configureRequest = CreateEditBasedElementCommand.this.createConfigureRequest();
                    ICommand configureCommand = CreateEditBasedElementCommand.this.getElementType().getEditCommand((IEditCommandRequest)configureRequest);
                    IStatus configureStatus = null;
                    if (configureCommand != null && configureCommand.canExecute()) {
                        configureStatus = configureCommand.execute(monitor, info);
                    }
                    CreateEditBasedElementCommand.this.getCreateRequest().setNewElement(CreateEditBasedElementCommand.this.newElement);
                    return configureStatus == null ? CommandResult.newOKCommandResult((Object)CreateEditBasedElementCommand.this.newElement) : new CommandResult(configureStatus, (Object)CreateEditBasedElementCommand.this.newElement);
                }
            };
            this.compositeEMFOperation.add((IUndoableOperation)configureTransactionalCommand);
        }
        return this.compositeEMFOperation;
    }

    protected boolean isPrepared() {
        return this.compositeEMFOperation != null;
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), this.newElement, this.getElementType());
        configureRequest.setClientContext(this.getCreateRequest().getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        return configureRequest;
    }

    protected boolean hasElementToEdit() {
        return this.elementToEdit != null;
    }

    protected void setElementToEdit(EObject element) {
        this.elementToEdit = element;
        super.setElementToEdit(element);
    }

    protected boolean canCreateChild() {
        boolean result = true;
        Object context = this.getRequest().getEditHelperContext();
        if (context instanceof EObject) {
            EObject owner = (EObject)context;
            EReference reference = this.getContainmentFeature();
            if (reference != null && !reference.isMany() && owner.eClass().getEAllReferences().contains((Object)reference)) {
                result = ((EObject)context).eGet((EStructuralFeature)reference) == null;
            }
        }
        return result;
    }

    public void dispose() {
        if (this.isPrepared()) {
            this.compositeEMFOperation.dispose();
            this.compositeEMFOperation = null;
        }
        super.dispose();
    }

    protected final class CreateEditBasedElementTransactionalCommand
    extends AbstractTransactionalCommand {
        private Collection<Command> possibleCommands;
        private Command commandDone;

        protected CreateEditBasedElementTransactionalCommand(TransactionalEditingDomain domain, String label, List<?> affectedFiles) {
            super(domain, label, affectedFiles);
        }

        public boolean canExecute() {
            return CreateEditBasedElementCommand.this.canCreateChild() && (!CreateEditBasedElementCommand.this.hasElementToEdit() || !this.getPossibleCommands().isEmpty());
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Command command = this.prepareCommand();
            if (command.canExecute()) {
                command.execute();
                return CommandResult.newOKCommandResult((Object)CreateEditBasedElementCommand.this.newElement);
            }
            return CommandResult.newErrorCommandResult((String)"Impossible to create Element");
        }

        protected Collection<Command> getPossibleCommands() {
            if (this.possibleCommands == null) {
                EReference containment;
                EObject element;
                this.possibleCommands = new HashSet<Command>();
                EClass eClass = CreateEditBasedElementCommand.this.getElementType().getEClass();
                ArrayList<EClass> eClassesToCreateCommandsFor = new ArrayList<EClass>();
                if (eClass.isAbstract()) {
                    if (CreateEditBasedElementCommand.this.eClassHint == null) {
                        eClassesToCreateCommandsFor.addAll(EMFHelper.getSubclassesOf((EClass)eClass, (boolean)true));
                    } else {
                        eClassesToCreateCommandsFor.add(CreateEditBasedElementCommand.this.eClassHint);
                    }
                } else {
                    eClassesToCreateCommandsFor.add(eClass);
                }
                if (eClassesToCreateCommandsFor.isEmpty()) {
                    this.possibleCommands.add((Command)UnexecutableCommand.INSTANCE);
                }
                if ((element = CreateEditBasedElementCommand.this.getElementToEdit()) != null && (containment = CreateEditBasedElementCommand.this.getContainmentFeature()) != null) {
                    IEditingDomainItemProvider editingDomainItemProvider = AdapterFactoryEditingDomain.getEditingDomainItemProviderFor((Object)element);
                    ResourceSet resourceSet = EMFHelper.getResourceSet((EObject)element);
                    for (EClass eClassToCreateCommandsFor : eClassesToCreateCommandsFor) {
                        EObject newElement = this.getFactory(eClassToCreateCommandsFor, resourceSet).create(eClassToCreateCommandsFor);
                        Command possibleCommand = editingDomainItemProvider.createCommand((Object)element, (EditingDomain)this.getEditingDomain(), CreateChildCommand.class, new CommandParameter((Object)element, (Object)containment, (Object)new CommandParameter(null, (Object)containment, (Object)newElement)));
                        if (possibleCommand == null) {
                            this.possibleCommands.add((Command)UnexecutableCommand.INSTANCE);
                            continue;
                        }
                        if (!possibleCommand.canExecute()) continue;
                        this.possibleCommands.add(possibleCommand);
                    }
                }
            }
            return this.possibleCommands;
        }

        EFactory getFactory(EClass eClass, ResourceSet resourceSet) {
            EFactory result = null;
            if (resourceSet != null) {
                result = resourceSet.getPackageRegistry().getEFactory(eClass.getEPackage().getNsURI());
            }
            if (result == null) {
                result = eClass.getEPackage().getEFactoryInstance();
            }
            return result;
        }

        protected Command prepareCommand() {
            if (this.commandDone == null) {
                EObject element;
                EClass eClass;
                EReference containment;
                block12: {
                    containment = CreateEditBasedElementCommand.this.getContainmentFeature();
                    eClass = CreateEditBasedElementCommand.this.getElementType().getEClass();
                    if (eClass.isAbstract()) {
                        if (CreateEditBasedElementCommand.this.eClassHint == null) {
                            try {
                                ServicesRegistry registry = ServiceUtilsForResource.getInstance().getServiceRegistry(CreateEditBasedElementCommand.this.getElementToEdit().eResource());
                                if (registry != null) {
                                    LabelProviderService labelProviderService = (LabelProviderService)registry.getService(LabelProviderService.class);
                                    if (labelProviderService != null) {
                                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), labelProviderService.getLabelProvider());
                                        dialog.setTitle("Metaclass selection");
                                        dialog.setMessage("Select the a concrete sub-metaclass of " + eClass.getName());
                                        dialog.setElements(EMFHelper.getSubclassesOf((EClass)eClass, (boolean)true).toArray());
                                        dialog.setMultipleSelection(false);
                                        dialog.open();
                                        Object[] results = dialog.getResult();
                                        if (results != null && results.length > 0 && results[0] instanceof EClass) {
                                            eClass = (EClass)results[0];
                                        }
                                    } else {
                                        Activator.log.error((Throwable)new NullPointerException());
                                        this.commandDone = UnexecutableCommand.INSTANCE;
                                    }
                                    break block12;
                                }
                                Activator.log.error((Throwable)new NullPointerException());
                                this.commandDone = UnexecutableCommand.INSTANCE;
                            }
                            catch (ServiceException e) {
                                Activator.log.error((Throwable)e);
                                this.commandDone = UnexecutableCommand.INSTANCE;
                            }
                        } else {
                            eClass = CreateEditBasedElementCommand.this.eClassHint;
                        }
                    }
                }
                if (containment != null && (element = CreateEditBasedElementCommand.this.getElementToEdit()) != null) {
                    ResourceSet resourceSet = EMFHelper.getResourceSet((EObject)element);
                    CreateEditBasedElementCommand.this.newElement = this.getFactory(eClass, resourceSet).create(eClass);
                    IEditingDomainItemProvider editingDomainItemProvider = AdapterFactoryEditingDomain.getEditingDomainItemProviderFor((Object)element);
                    this.commandDone = editingDomainItemProvider.createCommand((Object)element, (EditingDomain)this.getEditingDomain(), CreateChildCommand.class, new CommandParameter((Object)element, (Object)containment, (Object)new CommandParameter(null, (Object)containment, (Object)CreateEditBasedElementCommand.this.newElement)));
                }
                if (this.commandDone == null) {
                    this.commandDone = UnexecutableCommand.INSTANCE;
                }
            }
            return this.commandDone;
        }
    }
}

