/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.common.writing;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.papyrus.moka.xygraph.common.writing.ResourceBaseUpdateStrategy;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.TraceUpdateStrategy;
import org.eclipse.papyrus.moka.xygraph.model.reflection.TraceStructuralFeature;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;

public class ResourceTraceUpdateStrategy
extends ResourceBaseUpdateStrategy
implements TraceUpdateStrategy {
    private TransactionalEditingDomain domain;
    private CompoundCommand cc;

    public void updateTraceDescriptor(Trace trace, XYGraphWidgetBinder map) {
        TraceDescriptor tDesc = map.getDescriptorFor(trace);
        this.startTransactionalDomain(tDesc);
        this.updateAllFeatures(trace, map);
        this.commitUpdate();
    }

    private void startTransactionalDomain(TraceDescriptor tDesc) {
        if (this.cc != null) {
            return;
        }
        this.cc = new CompoundCommand();
        this.domain = this.getTransactionalEditingDomain(tDesc.eContainer().eResource());
    }

    private void commitTransaction() {
        if (this.cc == null) {
            return;
        }
        if (this.cc.canExecute()) {
            this.domain.getCommandStack().execute((Command)this.cc);
        }
        this.domain = null;
        this.cc = null;
    }

    public <T> void updateTraceFeature(TraceDescriptor tDesc, TraceStructuralFeature field, T newValue) {
        this.startTransactionalDomain(tDesc);
        this.appendSetCommand(this.cc, (EditingDomain)this.domain, (EObject)tDesc, field.getEStructuralFeature(), newValue);
    }

    public void commitUpdate() {
        this.commitTransaction();
    }
}

