/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.modeling.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceSpecificationGeneratorUtil {
    protected Package rootContainer;
    protected Map<Classifier, Integer> indexes = new HashMap<Classifier, Integer>();

    public InstanceSpecificationGeneratorUtil(Package rootContainer) {
        this.rootContainer = rootContainer;
    }

    public InstanceSpecification generateInstanceSpecification(Classifier classifier) {
        return this.generateInstanceSpecification(classifier, new ArrayList<Classifier>());
    }

    protected InstanceSpecification generateInstanceSpecification(Classifier classifier, List<Classifier> visited) {
        visited.add(classifier);
        String instanceSpecName = this.generateInstanceName(classifier);
        InstanceSpecification instanceSpec = (InstanceSpecification)this.rootContainer.createPackagedElement(instanceSpecName, UMLPackage.eINSTANCE.getInstanceSpecification());
        instanceSpec.getClassifiers().add((Object)classifier);
        for (Property p : classifier.getAllAttributes()) {
            if (!this.canGenerateSlot(classifier, p)) continue;
            Slot slot = instanceSpec.createSlot();
            slot.setDefiningFeature((StructuralFeature)p);
            if (p.getDefaultValue() != null) {
                ValueSpecification v = p.getDefaultValue();
                ValueSpecification copy = (ValueSpecification)EcoreUtil.copy((EObject)v);
                slot.getValues().add((Object)copy);
                copy.setName("valueFor " + p.getName());
                continue;
            }
            if (!this.canGenerateNewValue(classifier, p)) continue;
            Type type = p.getType();
            if (type instanceof Enumeration || type instanceof PrimitiveType) {
                this.generateValueSpecification(slot);
                continue;
            }
            if (visited.contains(type)) continue;
            ArrayList<Classifier> newVisited = new ArrayList<Classifier>();
            newVisited.addAll(visited);
            InstanceValue instanceValue = (InstanceValue)slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getInstanceValue());
            InstanceSpecification generatedInstanceSpec = this.generateInstanceSpecification((Classifier)p.getType(), newVisited);
            instanceValue.setInstance(generatedInstanceSpec);
        }
        return instanceSpec;
    }

    protected ValueSpecification generateValueSpecification(Slot slot) {
        Property p = (Property)slot.getDefiningFeature();
        Type type = p.getType();
        ValueSpecification v = null;
        if (type instanceof Enumeration) {
            v = slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getInstanceValue());
        } else if (type instanceof PrimitiveType) {
            String name = type.getName();
            if (name.equals("Integer")) {
                v = slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getLiteralInteger());
            } else if (name.equals("Boolean")) {
                v = slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getLiteralBoolean());
            } else if (name.equals("Real")) {
                v = slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getLiteralReal());
            } else if (name.equals("String")) {
                v = slot.createValue("valueFor " + p.getName(), type, UMLPackage.eINSTANCE.getLiteralString());
            }
        }
        return v;
    }

    protected String generateInstanceName(Classifier classifier) {
        int index = 0;
        if (this.indexes.get(classifier) == null) {
            index = 1;
        }
        this.indexes.put(classifier, index + 1);
        return classifier.getName().toLowerCase() + " " + index;
    }

    protected boolean canGenerateSlot(Classifier contextClassifier, Property property) {
        return true;
    }

    protected boolean canGenerateNewValue(Classifier contextClassifier, Property property) {
        if (property.getType() != null) {
            if (property.getType() instanceof Class) {
                return property.isComposite();
            }
            return true;
        }
        return false;
    }
}

