/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines;

import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.PseudostateActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.VertexActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IRegionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ITransitionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.TransitionMetadata;

public class JoinPseudostateActivation
extends PseudostateActivation {
    @Override
    public boolean isEnterable(ITransitionActivation enteringTransition, boolean staticCheck) {
        int i = 0;
        boolean isReady = true;
        while (isReady && i < this.incomingTransitionActivations.size()) {
            ITransitionActivation transitionActivation = (ITransitionActivation)this.incomingTransitionActivations.get(i);
            if (enteringTransition != transitionActivation) {
                isReady = transitionActivation.isTraversed(staticCheck);
            }
            ++i;
        }
        return isReady;
    }

    private boolean _canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        VertexActivation vertexActivation;
        IRegionActivation parentRegionActivation;
        boolean propagate = true;
        if (leastCommonAncestor != null && leastCommonAncestor != (parentRegionActivation = this.getOwningRegionActivation()) && (vertexActivation = (VertexActivation)parentRegionActivation.getParent()) != null) {
            propagate = vertexActivation.canPropagateExecution(enteringTransition, eventOccurrence, leastCommonAncestor);
        }
        return propagate;
    }

    @Override
    public boolean canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        enteringTransition.setAnalyticalStatus(TransitionMetadata.TRAVERSED);
        boolean propagate = this._canPropagateExecution(enteringTransition, eventOccurrence, leastCommonAncestor);
        if (propagate && this.isEnterable(enteringTransition, true)) {
            this.evaluateAllGuards(eventOccurrence);
            if (this.outgoingTransitionActivations.size() > 0) {
                propagate = false;
                if (this.fireableTransitions.size() > 0) {
                    int i = 0;
                    while (!propagate && i < this.fireableTransitions.size()) {
                        propagate = ((ITransitionActivation)this.fireableTransitions.get(i)).canPropagateExecution(eventOccurrence);
                        ++i;
                    }
                }
            }
            this.tagIncomingTransitions(TransitionMetadata.NONE, true);
        }
        return propagate;
    }

    @Override
    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        super.enter(enteringTransition, eventOccurrence, leastCommonAncestor);
        if (this.fireableTransitions.size() > 0) {
            ITransitionActivation selectedTransitionActivation = null;
            if (this.fireableTransitions.size() == 1) {
                selectedTransitionActivation = (ITransitionActivation)this.fireableTransitions.get(0);
            } else {
                ChoiceStrategy choiceStrategy = (ChoiceStrategy)this.getExecutionLocus().getFactory().getStrategy("choice");
                int chosenIndex = choiceStrategy.choose(Integer.valueOf(this.fireableTransitions.size()));
                selectedTransitionActivation = (ITransitionActivation)this.fireableTransitions.get(chosenIndex - 1);
            }
            selectedTransitionActivation.fire(eventOccurrence);
        }
    }
}

