/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine.control;

import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.fmu.communication.FMUInterface;
import org.eclipse.papyrus.moka.fmu.control.queue.FMIRootExecution;
import org.eclipse.papyrus.moka.fmu.engine.control.EngineStatus;
import org.eclipse.papyrus.moka.fmu.engine.de.FMUStepEnd;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUObject;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.fuml.control.execution.RootExecution;
import org.eclipse.papyrus.moka.fuml.control.queue.ExecutionController;
import org.eclipse.papyrus.moka.service.AbstractMokaService;
import org.eclipse.uml2.uml.Class;

public class FMUControlService
extends AbstractMokaService
implements FMUInterface {
    protected Semaphore instantiationLock = new Semaphore(0);
    protected Semaphore stepLock = new Semaphore(0);
    protected Semaphore engineLock = new Semaphore(0);
    protected Semaphore terminationLock = new Semaphore(0);
    protected EngineStatus engineStatus = EngineStatus.NOT_STARTED;
    protected FMIRootExecution fmiRootExecution;

    public EngineStatus getEngineStatus() {
        return this.engineStatus;
    }

    public void setEngineStatus(EngineStatus status) {
        this.engineStatus = status;
    }

    public void init(ILaunch launcher, EObject modelElement) {
        if (!(modelElement instanceof Class)) {
            return;
        }
        this.instantiationLock = new Semaphore(0);
        this.stepLock = new Semaphore(0);
        this.engineLock = new Semaphore(0);
        this.terminationLock = new Semaphore(0);
        FMUEngineUtils.setFMUControlService(this);
    }

    public FMUObject getFmuObject() {
        if (this.fmiRootExecution != null) {
            return this.fmiRootExecution.getFMUObject();
        }
        return null;
    }

    public void setRootExecution(FMIRootExecution rootExecution) {
        this.fmiRootExecution = rootExecution;
    }

    public Semaphore getInstantiationLock() {
        return this.instantiationLock;
    }

    public Semaphore getStepLock() {
        return this.stepLock;
    }

    public Semaphore getEngineLock() {
        return this.engineLock;
    }

    public Semaphore getTerminationLock() {
        return this.terminationLock;
    }

    @Override
    public void init() {
        Runnable controllerRunnable = new Runnable(){

            @Override
            public void run() {
                ExecutionController.getInstance().start((RootExecution)FMUControlService.this.fmiRootExecution);
            }
        };
        Thread controllerThread = new Thread(controllerRunnable);
        controllerThread.start();
        try {
            this.stepLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void doStep(double currentCommunicationTime, double stepSize) {
        FMUStepEnd stepEnd = new FMUStepEnd();
        DEScheduler.getInstance().pushEvent(new Event(stepSize, (Action)stepEnd), currentCommunicationTime + stepSize);
        this.engineLock.release();
        try {
            this.stepLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void terminate() {
        this.engineLock.release();
        this.stepLock.release();
        this.terminationLock.release();
    }

    public void waitForTermination() {
        try {
            this.terminationLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void updateMaps() {
        this.getFmuObject().updateMaps();
    }

    @Override
    public Map<Integer, Double> fmiGetReals() {
        return this.getFmuObject().fmiGetReals();
    }

    @Override
    public Map<Integer, Integer> fmiGetIntegers() {
        return this.getFmuObject().fmiGetIntegers();
    }

    @Override
    public Map<Integer, Boolean> fmiGetBools() {
        return this.getFmuObject().fmiGetBools();
    }

    @Override
    public Map<Integer, String> fmiGetStrings() {
        return this.getFmuObject().fmiGetStrings();
    }

    @Override
    public void fmiSetReals(Map<Integer, Double> realsMap) {
        this.getFmuObject().fmiSetReals(realsMap);
    }

    @Override
    public void fmiSetIntegers(Map<Integer, Integer> integersMap) {
        this.getFmuObject().fmiSetIntegers(integersMap);
    }

    @Override
    public void fmiSetBools(Map<Integer, Boolean> boolsMap) {
        this.getFmuObject().fmiSetBools(boolsMap);
    }

    @Override
    public void fmiSetStrings(Map<Integer, String> stringsMap) {
        this.getFmuObject().fmiSetStrings(stringsMap);
    }
}

