/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.profile.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.moka.datavisualization.profile.BooleanSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.DoubleSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.IntegerSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.StringSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.VisualizationFactory;
import org.eclipse.papyrus.moka.datavisualization.profile.VisualizationPackage;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.BooleanSeriesImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.DataSourceImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.DoubleSeriesImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.IntegerSeriesImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.StringSeriesImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.impl.ValueSeriesImpl;

public class VisualizationFactoryImpl
extends EFactoryImpl
implements VisualizationFactory {
    public static final String copyright = "Copyright (c) 2016 CEA LIST.\r\n\r\n All rights reserved. This program and the accompanying materials\r\n are made available under the terms of the Eclipse Public License v1.0\r\n which accompanies this distribution, and is available at\r\n http://www.eclipse.org/legal/epl-v10.html\r\n\r\n Contributors:\r\n  CEA LIST - Initial API and implementation";

    public static VisualizationFactory init() {
        try {
            VisualizationFactory theVisualizationFactory = (VisualizationFactory)EPackage.Registry.INSTANCE.getEFactory("https://www.eclipse.org/papyrus/datavisualization/1.0.0");
            if (theVisualizationFactory != null) {
                return theVisualizationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new VisualizationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDataSource();
            }
            case 1: {
                return this.createValueSeries();
            }
            case 2: {
                return this.createStringSeries();
            }
            case 3: {
                return this.createDoubleSeries();
            }
            case 4: {
                return this.createIntegerSeries();
            }
            case 5: {
                return this.createBooleanSeries();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public DataSource createDataSource() {
        DataSourceImpl dataSource = new DataSourceImpl();
        return dataSource;
    }

    @Override
    public ValueSeries createValueSeries() {
        ValueSeriesImpl valueSeries = new ValueSeriesImpl();
        return valueSeries;
    }

    @Override
    public StringSeries createStringSeries() {
        StringSeriesImpl stringSeries = new StringSeriesImpl();
        return stringSeries;
    }

    @Override
    public DoubleSeries createDoubleSeries() {
        DoubleSeriesImpl doubleSeries = new DoubleSeriesImpl();
        return doubleSeries;
    }

    @Override
    public IntegerSeries createIntegerSeries() {
        IntegerSeriesImpl integerSeries = new IntegerSeriesImpl();
        return integerSeries;
    }

    @Override
    public BooleanSeries createBooleanSeries() {
        BooleanSeriesImpl booleanSeries = new BooleanSeriesImpl();
        return booleanSeries;
    }

    @Override
    public VisualizationPackage getVisualizationPackage() {
        return (VisualizationPackage)this.getEPackage();
    }

    @Deprecated
    public static VisualizationPackage getPackage() {
        return VisualizationPackage.eINSTANCE;
    }
}

