/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmiprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DependenciesKind implements Enumerator
{
    DEPENDENT(0, "dependent", "dependent"),
    CONSTANT(1, "constant", "constant"),
    FIXED(2, "fixed", "fixed"),
    TUNABLE(3, "tunable", "tunable"),
    DISCRETE(4, "discrete", "discrete");

    public static final int DEPENDENT_VALUE = 0;
    public static final int CONSTANT_VALUE = 1;
    public static final int FIXED_VALUE = 2;
    public static final int TUNABLE_VALUE = 3;
    public static final int DISCRETE_VALUE = 4;
    private static final DependenciesKind[] VALUES_ARRAY;
    public static final List<DependenciesKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DependenciesKind[]{DEPENDENT, CONSTANT, FIXED, TUNABLE, DISCRETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DependenciesKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependenciesKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependenciesKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependenciesKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependenciesKind get(int value) {
        switch (value) {
            case 0: {
                return DEPENDENT;
            }
            case 1: {
                return CONSTANT;
            }
            case 2: {
                return FIXED;
            }
            case 3: {
                return TUNABLE;
            }
            case 4: {
                return DISCRETE;
            }
        }
        return null;
    }

    private DependenciesKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

