/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.rcp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.fmi.fmu.FMUParser;
import org.eclipse.papyrus.moka.fmu.engine.MokaEngineForFMUExport;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.fmu.json.JSONSocketClient;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPlugin;

public class FMURCPApplication
implements IApplication {
    private static final String FMU_PATH = "fmu";
    private static final String PORT_NUMBER = "port";
    public static final String MOKA_PROP_FILE_NAME = "moka.properties";
    public static final String MODEL_PATH_PROP = "model.path";
    public static final String FMU_QN = "fmu.qualifiedname";
    public static final String FMU_ID = "fmu.id";
    public static final String PROFILE_URI_MAP = "profile.map";
    public static final String URI_REMAP = "uri.map";

    public Object start(IApplicationContext context) throws Exception {
        System.out.println("FMU RCP Running");
        CommandLine cmdLine = this.parseArgs(context);
        if (cmdLine != null) {
            String unzippedFmuPath = cmdLine.getOptionValue(FMU_PATH);
            String portNumber = cmdLine.getOptionValue(PORT_NUMBER);
            if (portNumber == null) {
                throw new Exception("The argument port should be specified");
            }
            int portNumberInt = Integer.parseInt(portNumber);
            JSONSocketClient client = new JSONSocketClient(portNumberInt);
            FMUEngineUtils.setJSONSocketClient((JSONSocketClient)client);
            if (unzippedFmuPath == null) {
                throw new Exception("The argument fmu should be specified");
            }
            FMUParser handler = new FMUParser(unzippedFmuPath, false);
            File resourceFolder = handler.getResourceFolder();
            if (resourceFolder != null) {
                Properties mokaProp = new Properties();
                Throwable throwable = null;
                Object var11_12 = null;
                try (FileInputStream propFileStream = new FileInputStream(String.valueOf(resourceFolder.getAbsolutePath()) + File.separator + MOKA_PROP_FILE_NAME);){
                    mokaProp.load(propFileStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String modelPath = mokaProp.getProperty(MODEL_PATH_PROP);
                String fmuID = mokaProp.getProperty(FMU_ID);
                URI resURI = URI.createFileURI((String)(String.valueOf(resourceFolder.getAbsolutePath()) + "/" + modelPath));
                this.initProfileMap(mokaProp, resourceFolder.getAbsolutePath());
                ResourceSet resSet = this.initResourceSet(mokaProp, resourceFolder.getAbsolutePath());
                double startLoad = System.nanoTime();
                Class fmuClass = this.loadFMUClass(resSet, resURI, fmuID);
                System.out.println("FMU loaded:" + ((double)System.nanoTime() - startLoad) / 1000000.0 + "ms");
                if (fmuClass != null) {
                    this.launchSimulation(fmuClass);
                }
            } else {
                throw new Exception("FMU doesn't contain a resource folder");
            }
        }
        return IApplication.EXIT_OK;
    }

    private ResourceSet initResourceSet(Properties mokaProp, String resourceFolderPath) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("DEFER_ATTACHMENT", Boolean.valueOf(true));
        options.put("DEFER_IDREF_RESOLUTION", Boolean.valueOf(true));
        options.put("DISABLE_NOTIFY", Boolean.valueOf(true));
        options.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        options.put("USE_PARSER_POOL", (Serializable)new XMLParserPoolImpl());
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        resSet.getLoadOptions().putAll(options);
        this.initURIRemMap(mokaProp, resourceFolderPath, (ResourceSet)resSet);
        return resSet;
    }

    private void initURIRemMap(Properties mokaProp, String resourceFolder, ResourceSet resSet) {
        String propValue = mokaProp.getProperty(URI_REMAP);
        if (propValue != null) {
            String[] stringArray = propValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mapEntry = stringArray[n2];
                String[] entrySplit = mapEntry.split("=");
                String sourceURI = entrySplit[0];
                String targetURI = entrySplit[1];
                resSet.getURIConverter().getURIMap().put(URI.createURI((String)sourceURI), URI.createFileURI((String)(String.valueOf(resourceFolder) + "/" + targetURI)));
                ++n2;
            }
        }
    }

    private void initProfileMap(Properties mokaProp, String resourceFolder) {
        String propValue = mokaProp.getProperty(PROFILE_URI_MAP);
        if (propValue != null) {
            String[] stringArray = propValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mapEntry = stringArray[n2];
                String[] entrySplit = mapEntry.split("=");
                String ecorePackURI = entrySplit[0];
                String profileRelativeURI = entrySplit[1];
                String[] structuredProfileRelativeURI = profileRelativeURI.split("#");
                String profilePath = structuredProfileRelativeURI[0];
                String profileFragment = structuredProfileRelativeURI[1];
                UMLPlugin.getEPackageNsURIToProfileLocationMap().put(ecorePackURI, URI.createFileURI((String)(String.valueOf(resourceFolder) + "/" + profilePath)).appendFragment(profileFragment));
                ++n2;
            }
        }
    }

    private void launchSimulation(Class fmuClass) throws InterruptedException {
        MokaEngineForFMUExport engine = new MokaEngineForFMUExport();
        engine.init(null, (EObject)fmuClass, new String[0], IExecutionEngine.OperatingMode.NORMAL);
        engine.start((IProgressMonitor)new NullProgressMonitor());
        engine.waitForTermination();
    }

    private Class loadFMUClass(ResourceSet resSet, URI resURI, String fmuID) {
        if (resURI != null && fmuID != null) {
            Resource res = resSet.createResource(resURI);
            res.eSetDeliver(false);
            try {
                res.load(resSet.getLoadOptions());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (res != null) {
                return (Class)res.getEObject(fmuID);
            }
        }
        return null;
    }

    private CommandLine parseArgs(IApplicationContext context) {
        System.out.println("Starting Moka Application");
        Map argMap = context.getArguments();
        String[] appArgs = (String[])argMap.get("application.args");
        Options options = new Options();
        options.addOption(PORT_NUMBER, true, " JSON socket server port number");
        options.addOption(FMU_PATH, true, " path to the unzipped FMU folder");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, appArgs);
            return cmd;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void stop() {
    }
}

