/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine.semantics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_DefaultConstructStrategy;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Object;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fmu.communication.FMUInterface;
import org.eclipse.papyrus.moka.fmu.engine.control.EngineStatus;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUChangeEventOccurence;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IIntegerValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IRealValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStringValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.BooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.IntegerValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.RealValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.StringValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.ArrivalSignal;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.ObjectActivation;
import org.eclipse.papyrus.moka.timedfuml.semantics.Timed_Object;
import org.eclipse.papyrus.moka.utils.UMLPrimitiveTypesUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FMUObject
extends Timed_Object
implements FMUInterface,
IObject_ {
    protected Map<Integer, Double> realMap = new HashMap<Integer, Double>();
    protected Map<Integer, Integer> integerMap = new HashMap<Integer, Integer>();
    protected Map<Integer, Boolean> booleanMap = new HashMap<Integer, Boolean>();
    protected Map<Integer, String> stringMap = new HashMap<Integer, String>();
    protected Map<Integer, Property> indexToUMLPropertyMap;
    protected Map<Property, Integer> UMLPropertyToIndexMap;
    protected Map<String, Integer> UMLPropertyNameToIndexMap;

    @Override
    public void doStep(double currentCommunicationTime, double stepSize) {
    }

    @Override
    public void updateMaps() {
    }

    @Override
    public void init() {
        CS_DefaultConstructStrategy strategy = (CS_DefaultConstructStrategy)this.locus.getFactory().getStrategy("constructStrategy");
        strategy.constructObject((ICS_Object)this, (Class)this.types.get(0));
        for (IFeatureValue fv : this.getFeatureValues()) {
            this.synchronizeFeatureValueWithValueMaps(fv.getFeature(), fv.getValues());
        }
    }

    @Override
    public void terminate() {
    }

    public void setFeatureValue(StructuralFeature feature, List<IValue> values, Integer position) {
        super.setFeatureValue(feature, values, position);
        this.synchronizeFeatureValueWithValueMaps(feature, values);
    }

    protected void synchronizeFeatureValueWithValueMaps(StructuralFeature feature, List<IValue> values) {
        if (this.indexToUMLPropertyMap == null && this.UMLPropertyToIndexMap == null && this.UMLPropertyNameToIndexMap == null) {
            this.indexToUMLPropertyMap = new HashMap<Integer, Property>();
            this.UMLPropertyToIndexMap = new HashMap<Property, Integer>();
            this.UMLPropertyNameToIndexMap = new HashMap<String, Integer>();
            for (Property p : ((Class)this.types.get(0)).allAttributes()) {
                int index;
                if (!FMIProfileUtil.isFMUPort((StructuralFeature)p).booleanValue() || (index = FMIProfileUtil.getValueReference((Property)p)) == -1) continue;
                this.indexToUMLPropertyMap.put(index, p);
                this.UMLPropertyToIndexMap.put(p, index);
                this.UMLPropertyNameToIndexMap.put(p.getName(), index);
            }
        }
        if (FMIProfileUtil.isFMUPort((StructuralFeature)feature).booleanValue()) {
            int key = this.UMLPropertyToIndexMap.get(feature);
            Type featureType = feature.getType();
            if (featureType != null) {
                if (UMLUtil.isReal((Type)featureType)) {
                    IRealValue realValue = values.isEmpty() ? null : (IRealValue)values.get(0);
                    Double value = realValue == null ? null : realValue.getValue();
                    this.realMap.put(key, value);
                } else if (UMLUtil.isInteger((Type)featureType)) {
                    IIntegerValue integerValue = values.isEmpty() ? null : (IIntegerValue)values.get(0);
                    Integer value = integerValue == null ? null : integerValue.getValue();
                    this.integerMap.put(key, value);
                } else if (UMLUtil.isBoolean((Type)featureType)) {
                    IBooleanValue booleanValue = values.isEmpty() ? null : (IBooleanValue)values.get(0);
                    Boolean value = booleanValue == null ? null : booleanValue.getValue();
                    this.booleanMap.put(key, value);
                } else if (UMLUtil.isString((Type)featureType)) {
                    IStringValue stringValue = values.isEmpty() ? null : (IStringValue)values.get(0);
                    String value = stringValue == null ? null : stringValue.getValue();
                    this.stringMap.put(key, value);
                }
            }
        }
    }

    @Override
    public Map<Integer, Double> fmiGetReals() {
        return this.realMap;
    }

    @Override
    public Map<Integer, Integer> fmiGetIntegers() {
        return this.integerMap;
    }

    @Override
    public Map<Integer, Boolean> fmiGetBools() {
        return this.booleanMap;
    }

    @Override
    public Map<Integer, String> fmiGetStrings() {
        return this.stringMap;
    }

    @Override
    public void fmiSetReals(Map<Integer, Double> realsMap) {
        this.realMap.putAll(realsMap);
        for (Integer key : realsMap.keySet()) {
            Double new_;
            Double old;
            IRealValue realValue;
            Property p = this.indexToUMLPropertyMap.get(key);
            IFeatureValue fv = this.getFeatureValue((StructuralFeature)p);
            IRealValue iRealValue = realValue = fv.getValues().isEmpty() ? null : (IRealValue)fv.getValues().get(0);
            if (realValue == null) {
                realValue = new RealValue();
                realValue.setType(UMLPrimitiveTypesUtils.getReal((EObject)p));
                fv.getValues().add(realValue);
            }
            if (realValue.getValue() == null) continue;
            if (FMUEngineUtils.getFMUControlService().getEngineStatus() == EngineStatus.STEPPING && !(old = realValue.getValue()).equals(new_ = this.realMap.get(key))) {
                RealValue oldValue = new RealValue();
                oldValue.setType(UMLPrimitiveTypesUtils.getReal((EObject)p));
                oldValue.setValue(new_);
                FMUChangeEventOccurence changeEventOccurence = new FMUChangeEventOccurence(p, (IValue)oldValue, (IValue)realValue);
                this.getObjectActivation().getEvents().add(changeEventOccurence);
                ((ObjectActivation)this.getObjectActivation())._send(new ArrivalSignal());
            }
            realValue.setValue(realsMap.get(key));
        }
    }

    @Override
    public void fmiSetIntegers(Map<Integer, Integer> integersMap) {
        this.integerMap.putAll(integersMap);
        for (Integer key : integersMap.keySet()) {
            Integer new_;
            Integer old;
            IIntegerValue integerValue;
            Property p = this.indexToUMLPropertyMap.get(key);
            IFeatureValue fv = this.getFeatureValue((StructuralFeature)p);
            IIntegerValue iIntegerValue = integerValue = fv.getValues().isEmpty() ? null : (IIntegerValue)fv.getValues().get(0);
            if (integerValue == null) {
                integerValue = new IntegerValue();
                integerValue.setType(UMLPrimitiveTypesUtils.getInteger((EObject)p));
                fv.getValues().add(integerValue);
            }
            if (integerValue.getValue() == null) continue;
            if (FMUEngineUtils.getFMUControlService().getEngineStatus() == EngineStatus.STEPPING && !(old = integerValue.getValue()).equals(new_ = this.integerMap.get(key))) {
                IntegerValue oldValue = new IntegerValue();
                oldValue.setType(UMLPrimitiveTypesUtils.getInteger((EObject)p));
                oldValue.setValue(new_);
                FMUChangeEventOccurence changeEventOccurence = new FMUChangeEventOccurence(p, (IValue)oldValue, (IValue)integerValue);
                this.getObjectActivation().getEvents().add(changeEventOccurence);
                ((ObjectActivation)this.getObjectActivation())._send(new ArrivalSignal());
            }
            integerValue.setValue(this.integerMap.get(key));
        }
    }

    @Override
    public void fmiSetBools(Map<Integer, Boolean> boolsMap) {
        this.booleanMap.putAll(boolsMap);
        for (Integer key : boolsMap.keySet()) {
            Boolean new_;
            IBooleanValue booleanValue;
            Property p = this.indexToUMLPropertyMap.get(key);
            IFeatureValue fv = this.getFeatureValue((StructuralFeature)p);
            IBooleanValue iBooleanValue = booleanValue = fv.getValues().isEmpty() ? null : (IBooleanValue)fv.getValues().get(0);
            if (booleanValue == null) {
                booleanValue = new BooleanValue();
                booleanValue.setType(UMLPrimitiveTypesUtils.getBoolean((EObject)p));
                fv.getValues().add(booleanValue);
            }
            if (booleanValue.getValue() == null || FMUEngineUtils.getFMUControlService().getEngineStatus() != EngineStatus.STEPPING) continue;
            Boolean old = booleanValue.getValue();
            if (!old.equals(new_ = this.booleanMap.get(key))) {
                BooleanValue oldValue = new BooleanValue();
                oldValue.setType(UMLPrimitiveTypesUtils.getBoolean((EObject)p));
                oldValue.setValue(new_);
                FMUChangeEventOccurence changeEventOccurence = new FMUChangeEventOccurence(p, (IValue)oldValue, (IValue)booleanValue);
                this.getObjectActivation().getEvents().add(changeEventOccurence);
                ((ObjectActivation)this.getObjectActivation())._send(new ArrivalSignal());
            }
            booleanValue.setValue(this.booleanMap.get(key));
        }
    }

    @Override
    public void fmiSetStrings(Map<Integer, String> stringsMap) {
        this.stringMap.putAll(stringsMap);
        for (Integer key : stringsMap.keySet()) {
            String new_;
            String old;
            IStringValue stringValue;
            Property p = this.indexToUMLPropertyMap.get(key);
            IFeatureValue fv = this.getFeatureValue((StructuralFeature)p);
            IStringValue iStringValue = stringValue = fv.getValues().isEmpty() ? null : (IStringValue)fv.getValues().get(0);
            if (stringValue == null) {
                stringValue = new StringValue();
                stringValue.setType(UMLPrimitiveTypesUtils.getString((EObject)p));
                fv.getValues().add(stringValue);
            }
            if (stringValue.getValue() == null) continue;
            if (FMUEngineUtils.getFMUControlService().getEngineStatus() == EngineStatus.STEPPING && !(old = stringValue.getValue()).equals(new_ = this.stringMap.get(key))) {
                StringValue oldValue = new StringValue();
                oldValue.setType(UMLPrimitiveTypesUtils.getString((EObject)p));
                oldValue.setValue(new_);
                FMUChangeEventOccurence changeEventOccurence = new FMUChangeEventOccurence(p, (IValue)oldValue, (IValue)stringValue);
                this.getObjectActivation().getEvents().add(changeEventOccurence);
                ((ObjectActivation)this.getObjectActivation())._send(new ArrivalSignal());
            }
            stringValue.setValue(this.stringMap.get(key));
        }
    }

    public Map<Integer, Property> getIndexToUMLPropertyMap() {
        return this.indexToUMLPropertyMap;
    }

    public Map<String, Integer> getPropertyNameToIndexMap() {
        return this.UMLPropertyNameToIndexMap;
    }
}

