/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_DefaultRequestPropagationStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.Loci.LociL3.CS_Executor;
import org.eclipse.papyrus.moka.discreteevent.AbstractPushPullStrategy;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fmu.engine.de.FMIPushPullStrategy;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUConstructStrategy;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUExecutionFactory;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMULocus;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUObject;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.fmu.json.JSONSocketClient;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.IntermediateActions.CreateObjectActionStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.IntermediateActions.DefaultCreateObjectActionStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.IntermediateActions.DefaultGetAssociationStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.RedefinitionBasedDispatchStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.FIFOGetNextEventStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.FirstChoiceStrategy;
import org.eclipse.papyrus.moka.service.IMokaService;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;
import org.eclipse.papyrus.moka.timedfuml.TimedUmlExecutionEngine;
import org.eclipse.uml2.uml.Class;

public class MokaEngineForFMUExport
extends TimedUmlExecutionEngine {
    Thread mainThread = null;

    public void start(IProgressMonitor monitor) {
        if (!this.mode.equals((Object)IExecutionEngine.OperatingMode.QUIET)) {
            MokaServiceRegistry registry = MokaServiceRegistry.getInstance();
            registry.loadServices();
            for (IMokaService service : registry.getAllServices()) {
                service.init(this.launch, this.executionEntryPoint);
            }
        }
        Runnable execution = new Runnable(){

            @Override
            public void run() {
                Class fmuClass = FMUEngineUtils.getFMUControlService().getFmuClass();
                if (fmuClass != null) {
                    MokaEngineForFMUExport.this.startFMU(fmuClass);
                    DEScheduler.init((double)-1.0, (AbstractPushPullStrategy)new FMIPushPullStrategy());
                    JSONSocketClient client = FMUEngineUtils.getJsonSocketClient();
                    client.setFmu(FMUEngineUtils.getFMUControlService());
                    client.start();
                    FMUEngineUtils.getFMUControlService().waitForTermination();
                }
            }
        };
        this.mainThread = new Thread(execution, "Moka - Main thread");
        this.mainThread.start();
    }

    public void waitForTermination() throws InterruptedException {
        if (this.mainThread != null) {
            this.mainThread.join();
        }
    }

    public void startFMU(Class fmuClass) {
        if (fmuClass != null && FMIProfileUtil.isCS_FMU((Class)fmuClass).booleanValue()) {
            this.locus = new FMULocus();
            this.locus.setExecutor((IExecutor)new CS_Executor());
            this.locus.setFactory((IExecutionFactory)new FMUExecutionFactory());
            this.initializeBuiltInPrimitiveTypes(this.locus);
            this.registerOpaqueBehaviorExecutions(this.locus);
            this.registerSemanticStrategies(this.locus);
            this.registerSystemServices(this.locus);
            CreateObjectActionStrategy strategy = (CreateObjectActionStrategy)this.locus.getFactory().getStrategy("CreateObjectActionStrategy");
            FMUObject fmuObject = (FMUObject)strategy.instantiate(fmuClass, this.locus);
            FMUEngineUtils.getFMUControlService().setFmuObject(fmuObject);
        }
    }

    protected void registerSemanticStrategies(ILocus locus) {
        locus.getFactory().setStrategy((ISemanticStrategy)new FirstChoiceStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new FIFOGetNextEventStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new RedefinitionBasedDispatchStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new DefaultCreateObjectActionStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new DefaultGetAssociationStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_DispatchOperationOfInterfaceStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_DefaultRequestPropagationStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new FMUConstructStrategy());
    }
}

