/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.animation.engine.rendering.IAnimation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.service.IMokaExecutionListener;

public abstract class Animator
implements IMokaExecutionListener,
IAnimation {
    protected AnimationEngine engine;
    protected int priority;

    public AnimationEngine getAnimationEngine() {
        return this.engine;
    }

    public void setAnimationEngine(AnimationEngine engine) {
        this.engine = engine;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public abstract boolean accept(ISemanticVisitor var1);

    public void valueCreated(IValue value) {
    }

    public void valueDestroyed(IValue value) {
    }

    @Override
    public void renderAs(EObject modelElement, IObject_ object, AnimationKind targetStyle) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, object, targetStyle);
    }

    @Override
    public void renderAs(EObject modelElement, IObject_ object, AnimationKind sourceStyle, AnimationKind targetStyle, int duration) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, object, sourceStyle);
        if (duration >= 25) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.engine.stopRendering(modelElement, object, sourceStyle);
        this.engine.startRendering(modelElement, object, targetStyle);
    }
}

