/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications.AsyncEventPool;
import org.eclipse.papyrus.moka.async.fuml.debug.AsyncDebug;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IClassifierBehaviorInvocationEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.ClassifierBehaviorInvocationEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.InvocationEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.ObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.SignalEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.StandardOutputChannelImpl;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;

public class AsyncObjectActivation
extends ObjectActivation
implements Runnable {
    protected ObjectActivationState currentState = null;
    protected final Class classifier;
    protected final List<IParameterValue> inputs;
    protected AsyncEventPool evtPool;
    protected boolean hasBeenWaiting = false;
    protected static final IOConsoleOutputStream out = StandardOutputChannelImpl.getConsole().newOutputStream();

    public AsyncObjectActivation(Class classifier, List<IParameterValue> inputs) {
        this.classifier = classifier;
        this.inputs = inputs;
        this.evtPool = new AsyncEventPool(this);
    }

    @Override
    public void run() {
        block5: {
            this.currentState = ObjectActivationState.RUNNING;
            try {
                this.startBehavior(this.classifier, this.inputs);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (MokaConstants.SILENT_MODE) break block5;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Moka", (String)"An unexpected error occurred during execution. See error log for details.");
                    }
                });
            }
        }
        while (this.currentState.equals((Object)ObjectActivationState.RUNNING)) {
            block6: {
                try {
                    this.dispatchNextEvent();
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    if (MokaConstants.SILENT_MODE) break block6;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Moka", (String)"An unexpected error occurred during execution. See error log for details.");
                        }
                    });
                }
            }
            if (!this.waitingEventAccepters.isEmpty()) continue;
            this.currentState = ObjectActivationState.STOPPED;
        }
    }

    public ObjectActivationState getCurrentState() {
        return this.currentState;
    }

    public synchronized void send(IEventOccurrence eventOccurrence) {
        this.evtPool.send(eventOccurrence);
    }

    public IEventOccurrence getNextEvent() {
        if (this.evtPool.isEmpty()) {
            this.currentState = ObjectActivationState.WAITING;
            this.hasBeenWaiting = true;
        }
        IEventOccurrence eventOccurrence = this.evtPool.getNextEvent();
        this.currentState = ObjectActivationState.RUNNING;
        if (eventOccurrence != null) {
            if (eventOccurrence instanceof SignalEventOccurrence) {
                AsyncDebug.println((String)("[EVENT CONSUMED] occurrence for a signal:  " + ((SignalEventOccurrence)eventOccurrence).signalInstance));
            }
            if (eventOccurrence instanceof InvocationEventOccurrence) {
                AsyncDebug.println((String)("[EVENT CONSUMED] occurrence to start a classifier behavior: " + ((InvocationEventOccurrence)eventOccurrence).execution));
            }
        }
        return eventOccurrence;
    }

    public void startBehavior(Class classifier, List<IParameterValue> inputs) {
        if (classifier == null) {
            AsyncDebug.println((String)"Starting behavior for all classifiers...");
            List types = this.object.getTypes();
            for (Classifier type : types) {
                if (!(type instanceof Behavior | ((Class)type).getClassifierBehavior() != null)) continue;
                this.startBehavior((Class)type, new ArrayList<IParameterValue>());
            }
        } else {
            AsyncDebug.println((String)("Starting behavior for " + classifier.getName() + "..."));
            boolean notYetStarted = true;
            int i = 1;
            while (notYetStarted & i <= this.classifierBehaviorInvocations.size()) {
                notYetStarted = ((IClassifierBehaviorInvocationEventAccepter)this.classifierBehaviorInvocations.get(i - 1)).getExecutedClassifier() != classifier;
                ++i;
            }
            if (notYetStarted) {
                ClassifierBehaviorInvocationEventAccepter newInvocation = new ClassifierBehaviorInvocationEventAccepter();
                newInvocation.objectActivation = this;
                this.classifierBehaviorInvocations.add(newInvocation);
                newInvocation.invokeBehavior(classifier, inputs);
                InvocationEventOccurrence eventOccurrence = new InvocationEventOccurrence();
                eventOccurrence.execution = newInvocation.execution;
                this.evtPool.send((IEventOccurrence)eventOccurrence);
            }
        }
    }

    public void stop() {
        super.stop();
        this.currentState = ObjectActivationState.STOPPED;
    }

    public void dispatchNextEvent() {
        IEventOccurrence eventOccurrence = this.getNextEvent();
        AsyncDebug.println((String)("[dispatchNextEvent] eventOccurrence = " + eventOccurrence));
        ArrayList<Integer> matchingEventAccepterIndexes = new ArrayList<Integer>();
        List waitingEventAccepters = this.waitingEventAccepters;
        int i = 0;
        while (i < waitingEventAccepters.size()) {
            IEventAccepter eventAccepter = (IEventAccepter)waitingEventAccepters.get(i);
            if (eventAccepter.match(eventOccurrence).booleanValue()) {
                matchingEventAccepterIndexes.add(i);
            }
            ++i;
        }
        if (matchingEventAccepterIndexes.size() > 0) {
            int j = ((ChoiceStrategy)this.object.getLocus().getFactory().getStrategy("choice")).choose(Integer.valueOf(matchingEventAccepterIndexes.size()));
            IEventAccepter selectedEventAccepter = (IEventAccepter)this.waitingEventAccepters.get((Integer)matchingEventAccepterIndexes.get(j - 1));
            this.waitingEventAccepters.remove(selectedEventAccepter);
            if (this.hasBeenWaiting) {
                this.hasBeenWaiting = false;
            }
            selectedEventAccepter.accept(eventOccurrence);
        } else {
            AsyncDebug.printLostSignal(eventOccurrence, this, out);
        }
    }

    public static enum ObjectActivationState {
        RUNNING,
        STOPPED,
        WAITING;

    }
}

