/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.Constants;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.JavaGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaAttribute;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaDocumentation;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaParameter;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaTypedElement;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Default;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaOperations {
    public static CharSequence javaOperationImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        String _body = GenUtils.getBody((Operation)operation, (Pattern)Constants.supportedLanguages);
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String javaReturnSpec(Operation operation) {
        String _xifexpression = null;
        boolean _isConstructor = JavaOperations.isConstructor(operation);
        if (_isConstructor) {
            _xifexpression = JavaOperations.constructorOrVoid(operation);
        } else {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.OUT_LITERAL);
                }
            };
            String _javaTypeOrVoid = JavaOperations.javaTypeOrVoid((Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)operation.getOwnedParameters(), (Functions.Function1)_function)));
            _xifexpression = String.valueOf(_javaTypeOrVoid) + " ";
        }
        return _xifexpression;
    }

    public static String javaSECReturnSpec(Operation operation) {
        String _xifexpression = null;
        boolean _isConstructor = JavaOperations.isConstructor(operation);
        if (_isConstructor) {
            _xifexpression = JavaOperations.constructorOrVoid(operation);
        } else {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.OUT_LITERAL);
                }
            };
            String _javaSECTypeOrVoid = JavaOperations.javaSECTypeOrVoid((Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)operation.getOwnedParameters(), (Functions.Function1)_function)));
            _xifexpression = String.valueOf(_javaSECTypeOrVoid) + " ";
        }
        return _xifexpression;
    }

    public static String javaTypeOrVoid(Parameter parameter) {
        if (parameter != null) {
            return JavaTypedElement.javaType((TypedElement)parameter);
        }
        return "void";
    }

    public static String javaSECTypeOrVoid(Parameter parameter) {
        if (parameter != null) {
            return parameter.getName().substring(5);
        }
        return "void";
    }

    public static CharSequence throwss(Operation operation) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _length = ((Object[])Conversions.unwrapArray((Object)operation.getRaisedExceptions(), Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("throws ");
            EList _raisedExceptions = operation.getRaisedExceptions();
            boolean _hasElements = false;
            for (Type re : _raisedExceptions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _name = re.getName();
                _builder.append(_name);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String constructorOrVoid(Operation operation) {
        String _xifexpression = null;
        boolean _isConstructor = JavaOperations.isConstructor(operation);
        _xifexpression = _isConstructor ? "" : "void ";
        return _xifexpression;
    }

    public static boolean isConstructor(Operation operation) {
        return GenUtils.hasStereotype((Element)operation, Create.class);
    }

    public static Collection<Operation> getOwnedOperations(Classifier cl) {
        EList<Operation> _xblockexpression = null;
        EList<Operation> operations = JavaOperations.getOwnedOperationsWNull(cl);
        EList<Operation> _xifexpression = null;
        _xifexpression = operations == null ? CollectionLiterals.emptySet() : operations;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EList<Operation> getOwnedOperationsWNull(Classifier cl) {
        EList _xifexpression = null;
        if (cl instanceof Class) {
            _xifexpression = ((Class)cl).getOwnedOperations();
        } else {
            EList _xifexpression_1 = null;
            if (cl instanceof DataType) {
                _xifexpression_1 = ((DataType)cl).getOwnedOperations();
            } else {
                EList _xifexpression_2 = null;
                _xifexpression_2 = cl instanceof Interface ? ((Interface)cl).getOwnedOperations() : null;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence javaOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        String _methodModifiers = Modifier.methodModifiers(operation);
        _builder.append(_methodModifiers, "\t");
        String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
        _builder.append(_javaReturnSpec, "\t");
        String _name = operation.getName();
        _builder.append(_name, "\t");
        _builder.append("(");
        CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
        _builder.append((Object)_javaOperationParameters, "\t");
        _builder.append(") ");
        CharSequence _throwss = JavaOperations.throwss(operation);
        _builder.append((Object)_throwss, "\t");
        boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody) {
            _builder.append("{");
        } else {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_1) {
            CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
            _builder.append((Object)_javaOperationImplementation, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_2) {
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence javaAASOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _javaAASOperationDoc = JavaDocumentation.javaAASOperationDoc(operation);
        _builder.append((Object)_javaAASOperationDoc, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _methodModifiers = Modifier.methodModifiers(operation);
        _builder.append(_methodModifiers, "\t");
        String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
        _builder.append(_javaReturnSpec, "\t");
        Element _owner = operation.getOwner();
        String _name = ((NamedElement)_owner).getName();
        _builder.append(_name, "\t");
        _builder.append("_");
        String _name_1 = operation.getName();
        _builder.append(_name_1, "\t");
        _builder.append("(");
        CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
        _builder.append((Object)_javaOperationParameters, "\t");
        _builder.append(") ");
        CharSequence _throwss = JavaOperations.throwss(operation);
        _builder.append((Object)_throwss, "\t");
        boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody) {
            _builder.append("{");
        } else {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Boolean _hasOpaqueBehavior = JavaGenUtils.hasOpaqueBehavior(operation);
        if (_hasOpaqueBehavior.booleanValue()) {
            CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
            _builder.append((Object)_javaOperationImplementation, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        } else {
            CharSequence _javaAASOperationImplementation = JavaOperations.javaAASOperationImplementation(operation);
            _builder.append((Object)_javaAASOperationImplementation, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_1) {
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence javaAASOperationImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasReturnType = JavaOperations.hasReturnType(operation);
        if (_hasReturnType) {
            _builder.append("return (");
            String _returnType = JavaOperations.getReturnType(operation);
            _builder.append(_returnType);
            _builder.append(") ");
            Element _owner = operation.getOwner();
            String _name = ((Classifier)_owner).getName();
            _builder.append(_name);
            _builder.append(".");
            Element _owner_1 = operation.getOwner();
            String _name_1 = ((Classifier)_owner_1).getName();
            _builder.append(_name_1);
            _builder.append("_");
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.OUT_LITERAL);
                }
            };
            String _name_2 = ((Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)operation.getOwnedParameters(), (Functions.Function1)_function))).getName();
            _builder.append(_name_2);
            _builder.append("_");
            String _name_3 = operation.getName();
            _builder.append(_name_3);
            _builder.append("_Output.getValue();\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence javaGetOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _javaGetOperationDoc = JavaDocumentation.javaGetOperationDoc(operation);
        _builder.append((Object)_javaGetOperationDoc, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _methodModifiers = Modifier.methodModifiers(operation);
        _builder.append(_methodModifiers, "\t");
        String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
        _builder.append(_javaReturnSpec, "\t");
        String _name = operation.getName();
        _builder.append(_name, "\t");
        _builder.append("(");
        CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
        _builder.append((Object)_javaOperationParameters, "\t");
        _builder.append(") ");
        CharSequence _throwss = JavaOperations.throwss(operation);
        _builder.append((Object)_throwss, "\t");
        boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody) {
            _builder.append("{");
        } else {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_1) {
            CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
            _builder.append((Object)_javaOperationImplementation, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_2) {
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence javagetOperationDeclaration(Property property, Classifier c) {
        StringConcatenation _builder = new StringConcatenation();
        Boolean _isOperationExists = JavaGenUtils.isOperationExists(c, property);
        if (_isOperationExists.booleanValue()) {
            CharSequence _javaGetOperationDeclaration = JavaOperations.javaGetOperationDeclaration(JavaGenUtils.getOperation(c, property));
            _builder.append((Object)_javaGetOperationDeclaration);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _javaPropertyAttributeDeclaration = JavaAttribute.javaPropertyAttributeDeclaration(property);
            _builder.append((Object)_javaPropertyAttributeDeclaration);
            _builder.append(" get_");
            Element _owner = property.getOwner();
            String _name = ((NamedElement)_owner).getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = property.getName();
            _builder.append(_name_1);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            CharSequence _javaPropertyAttributeBody = JavaAttribute.javaPropertyAttributeBody(property);
            _builder.append((Object)_javaPropertyAttributeBody);
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public static boolean isAbstract(Operation operation) {
        return operation.isAbstract() && operation.getOwner() instanceof Classifier && (((Classifier)operation.getOwner()).isAbstract() || operation.getOwner() instanceof Enumeration) || operation.getInterface() != null;
    }

    public static boolean isDefault(Operation operation) {
        return operation.getInterface() != null && UMLUtil.getStereotypeApplication((Element)operation, Default.class) != null;
    }

    public static boolean mustGenerateBody(Operation operation) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean _not;
        boolean _isAbstract = JavaOperations.isAbstract(operation);
        boolean bl = _not = !_isAbstract;
        if (_not) {
            return true;
        }
        Interface _interface = operation.getInterface();
        boolean bl2 = _tripleEquals = _interface == null;
        if (_tripleEquals) {
            boolean _isStatic = operation.isStatic();
            return _isStatic;
        }
        Interface _interface_1 = operation.getInterface();
        boolean bl3 = _tripleNotEquals = _interface_1 != null;
        if (_tripleNotEquals) {
            return operation.isStatic() || UMLUtil.getStereotypeApplication((Element)operation, Default.class) != null;
        }
        return true;
    }

    public static boolean hasReturnType(Operation operation) {
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.OUT_LITERAL);
            }
        };
        boolean _equals = JavaOperations.javaTypeOrVoid((Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)operation.getOwnedParameters(), (Functions.Function1)_function))).equals("void");
        return !_equals;
    }

    public static String getReturnType(Operation operation) {
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.OUT_LITERAL);
            }
        };
        return JavaOperations.javaTypeOrVoid((Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)operation.getOwnedParameters(), (Functions.Function1)_function)));
    }

    public static CharSequence javaOperationSECDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        if (operation != null) {
            CharSequence _javaGetSECOperationDoc = JavaDocumentation.javaGetSECOperationDoc(operation);
            _builder.append((Object)_javaGetSECOperationDoc);
            _builder.newLineIfNotEmpty();
            String _methodModifiers = Modifier.methodModifiers(operation);
            _builder.append(_methodModifiers);
            String _javaSECReturnSpec = JavaOperations.javaSECReturnSpec(operation);
            _builder.append(_javaSECReturnSpec);
            String _name = operation.getName();
            _builder.append(_name);
            _builder.append("(");
            CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
            _builder.append((Object)_javaOperationParameters);
            _builder.append(") ");
            CharSequence _throwss = JavaOperations.throwss(operation);
            _builder.append((Object)_throwss);
            boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
            if (_mustGenerateBody) {
                _builder.append("{");
            } else {
                _builder.append(";");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
            if (_mustGenerateBody_1) {
                CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
                _builder.append((Object)_javaOperationImplementation, "\t");
            }
            _builder.newLineIfNotEmpty();
            boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
            if (_mustGenerateBody_2) {
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

