/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.validation.constraints;

import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.aas.IdType;
import org.eclipse.papyrus.aas.NodeId;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.papyrus.aas.codegen.ui.handlers.GenerateAASCodeHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PropertyNodeIdConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        IStatus status;
        block22: {
            IdType idType;
            NodeId umlNodeid;
            NamedElement elt;
            Property pr;
            status = ctx.createSuccessStatus();
            if (!(ctx.getTarget() instanceof NamedElement) || (pr = (Property)UMLUtil.getStereotypeApplication((Element)(elt = (NamedElement)ctx.getTarget()), Property.class)) == null || !(elt instanceof org.eclipse.uml2.uml.Property) || (umlNodeid = pr.getNodeId()) == null || (idType = umlNodeid.getIdType()).getLiteral() == null) break block22;
            switch (idType.getLiteral()) {
                case "Integer": {
                    try {
                        Integer.parseInt(umlNodeid.getIdentifier());
                    }
                    catch (NumberFormatException e) {
                        status = ctx.createFailureStatus(new Object[]{"NodeId Identifier must have an Integer value"});
                    }
                    break;
                }
                case "Long": {
                    try {
                        Long.parseLong(umlNodeid.getIdentifier());
                    }
                    catch (NumberFormatException e) {
                        status = ctx.createFailureStatus(new Object[]{"NodeId Identifier must have a Long value"});
                    }
                    break;
                }
                case "ByteArray": {
                    if (GenerateAASCodeHelper.convertStringtoByteArray((String)umlNodeid.getIdentifier()) != null) break;
                    status = ctx.createFailureStatus(new Object[]{"NodeId Identifier must have a ByteArray value"});
                    break;
                }
                case "UUID": {
                    try {
                        UUID.fromString(umlNodeid.getIdentifier());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        status = ctx.createFailureStatus(new Object[]{"NodeId Identifier must have a UUID value"});
                    }
                }
            }
        }
        return status;
    }
}

