/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.widgets;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.aas.AASFactory;
import org.eclipse.papyrus.aas.Endpoint;
import org.eclipse.papyrus.aas.ProtocolKind;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.papyrus.infra.widgets.providers.UnsetObject;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class EndPointComboDialog
extends StringCombo {
    private Timer timer;
    private TimerTask changeColorTask;
    private IBaseLabelProvider labelprovider;

    public EndPointComboDialog(Composite parent, int style) {
        super(parent, style, null, true);
        this.labelprovider = this.viewer.getLabelProvider();
    }

    protected IObservableValue getObservableValue() {
        return new CComboObservableValue();
    }

    class CComboObservableValue
    extends AbstractObservableValue
    implements SelectionListener,
    KeyListener,
    FocusListener {
        private String previousValue;

        public CComboObservableValue() {
            this.previousValue = EndPointComboDialog.this.combo.getText();
            EndPointComboDialog.this.combo.addSelectionListener((SelectionListener)this);
            EndPointComboDialog.this.combo.addKeyListener((KeyListener)this);
            EndPointComboDialog.this.combo.addFocusListener((FocusListener)this);
        }

        public Object getValueType() {
            return String.class;
        }

        protected String doGetValue() {
            return EndPointComboDialog.this.combo.getText();
        }

        protected void doSetValue(Object value) {
            if (EndPointComboDialog.this.modelProperty instanceof AggregatedObservable && ((AggregatedObservable)EndPointComboDialog.this.modelProperty).hasDifferentValues()) {
                EndPointComboDialog.this.combo.setText(UnchangedObject.instance.toString());
            } else if (value instanceof String) {
                this.previousValue = (String)value;
                EndPointComboDialog.this.combo.setText(this.previousValue);
            }
        }

        public void keyReleased(KeyEvent e) {
            if ((e.keyCode == 13 || e.keyCode == 0x1000050) && e.stateMask == 0) {
                this.maybeFireChange();
                e.doit = false;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.maybeFireChange();
        }

        public void focusLost(FocusEvent e) {
            this.maybeFireChange();
        }

        void maybeFireChange() {
            String currentValue = this.doGetValue();
            if (currentValue == null ? this.previousValue != null : !currentValue.equals(this.previousValue)) {
                this.doFireChange();
            }
        }

        private void doFireChange() {
            final String oldValue = this.previousValue;
            final String currentValue = this.previousValue = this.doGetValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return currentValue;
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    }

    class EndPointComboObservableValue
    extends AbstractObservableValue
    implements SelectionListener,
    KeyListener,
    FocusListener {
        private Object previousValue;

        public EndPointComboObservableValue(Viewer viewer2, IObservableValue modelProperty2) {
            EndPointComboDialog.this.viewer = (ComboViewer)viewer2;
            EndPointComboDialog.this.modelProperty = modelProperty2;
            this.previousValue = EndPointComboDialog.this.viewer.getSelection();
            EndPointComboDialog.this.combo.addSelectionListener((SelectionListener)this);
            EndPointComboDialog.this.combo.addKeyListener((KeyListener)this);
            EndPointComboDialog.this.combo.addFocusListener((FocusListener)this);
            EndPointComboDialog.this.viewer.setComparer((IElementComparer)new EndPointComparator());
            EndPointComboDialog.this.setViewer(EndPointComboDialog.this.viewer);
        }

        public Object getValueType() {
            return Endpoint.class;
        }

        protected Object doGetValue() {
            ISelection selection = EndPointComboDialog.this.viewer.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement == UnsetObject.instance) {
                    return null;
                }
                if (firstElement == UnchangedObject.instance) {
                    return null;
                }
                return firstElement;
            }
            return null;
        }

        private Endpoint getEndpoint(String endpoint) {
            if (endpoint != "") {
                Endpoint endPoint = AASFactory.eINSTANCE.createEndpoint();
                String[] propertiesValues = endpoint.substring(1, endpoint.length() - 1).split(",");
                int i = 0;
                while (i < propertiesValues.length) {
                    propertiesValues[i] = propertiesValues[i].split("=")[1];
                    ++i;
                }
                endPoint.setAddress(propertiesValues[0]);
                endPoint.setName(propertiesValues[2]);
                endPoint.setProtocol(ProtocolKind.get((String)propertiesValues[1]));
                return endPoint;
            }
            return null;
        }

        protected void doSetValue(Object value) {
            if (EndPointComboDialog.this.modelProperty instanceof AggregatedObservable && ((AggregatedObservable)EndPointComboDialog.this.modelProperty).hasDifferentValues()) {
                EndPointComboDialog.this.combo.setText(UnchangedObject.instance.toString());
            } else if (value instanceof Endpoint) {
                this.previousValue = value;
                EndPointComboDialog.this.combo.setText(((ILabelProvider)EndPointComboDialog.this.viewer.getLabelProvider()).getText(this.previousValue));
            }
        }

        public void keyReleased(KeyEvent e) {
            if ((e.keyCode == 13 || e.keyCode == 0x1000050) && e.stateMask == 0) {
                this.maybeFireChange();
                e.doit = false;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.maybeFireChange();
        }

        public void focusLost(FocusEvent e) {
            this.maybeFireChange();
        }

        void maybeFireChange() {
            Object currentValue = this.doGetValue();
            if (currentValue != null && !new EndPointComparator().equals(currentValue, this.previousValue)) {
                this.doFireChange();
            }
        }

        private boolean aredifferent(Endpoint currentValue, Endpoint previousValue2) {
            if (previousValue2 == null) {
                return true;
            }
            return !currentValue.getName().equals(previousValue2.getName()) || !currentValue.getProtocol().equals((Object)previousValue2.getProtocol()) || !currentValue.getAddress().equals(previousValue2.getAddress());
        }

        private void doFireChange() {
            Object currentValue;
            final Object oldValue = this.previousValue;
            this.previousValue = currentValue = this.doGetValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return currentValue;
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    }

    private static final class EndPointComparator
    implements IElementComparer {
        private EndPointComparator() {
        }

        public boolean equals(Object a, Object b) {
            String adress2;
            String adress;
            return a instanceof Endpoint && b instanceof Endpoint && (adress = ((Endpoint)a).getAddress()).equals(adress2 = ((Endpoint)b).getAddress());
        }

        public int hashCode(Object element) {
            return 0;
        }
    }
}

