/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.widgets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.aas.ConceptDescription;
import org.eclipse.papyrus.aas.HasSemantics;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.aas.profile.ui.Activator;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattableFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.Style;
import org.eclipse.papyrus.infra.nattable.resource.TableResourceHelper;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.ui.modelelement.CompositeModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrus.uml.properties.modelelement.UMLNotationModelElement;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AASNattablePropertyEditor
extends AbstractPropertyEditor {
    @Deprecated
    private static final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
    private static final String TABLES_PREFERENCES_FOLDER_NAME = "tables";
    @Deprecated
    private static final String FILE_EXTENSION = "table";
    protected Group self = null;
    private URI tableConfigURI = null;
    protected NatTable natTableWidget = null;
    protected INattableModelManager nattableManager = null;
    private DisposeListener nattableDisposeListener = null;
    private IDataSourceListener dataSourceListener;
    private ServicesRegistry serviceRegistry = null;
    private Resource resource = null;
    private Table table = null;
    private TableConfiguration tableConfiguration = null;
    private boolean registerTableConfigurationByEClass = false;

    static {
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        saveOptions.put("SAVE_TYPE_INFORMATION", true);
    }

    public AASNattablePropertyEditor(Composite parent, int style) {
        this.self = new Group(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        this.self.setLayout((Layout)fillLayout);
    }

    public final void setRegisterTableConfigurationByEClass(boolean newValue) {
        this.registerTableConfigurationByEClass = newValue;
    }

    public void setTableConfigurationURI(String uri) {
        this.tableConfigURI = URI.createURI((String)uri);
        this.checkInput();
    }

    public String getTableConfigurationURI() {
        return this.tableConfigURI == null ? null : this.tableConfigURI.toString();
    }

    @Deprecated
    public void setTableURI(String uri) {
        this.setTableConfigurationURI(uri);
    }

    @Deprecated
    public String getTableURI() {
        return this.getTableConfigurationURI();
    }

    protected void checkInput() {
        if (this.tableConfigURI != null) {
            super.checkInput();
        }
    }

    protected void doBinding() {
        super.doBinding();
        ModelElement modelElement = null;
        ModelElement modelElementHassemantic = this.input.getModelElement("AAS:HasSemantics:semanticId");
        ModelElement modelElementConceptDescription = this.input.getModelElement("AAS:ConceptDescription:isCaseOf");
        ArrayList<ModelElement> modelElements = new ArrayList<ModelElement>(Arrays.asList(modelElementHassemantic, modelElementConceptDescription));
        if (modelElements.stream().filter(Objects::nonNull).findAny().isPresent()) {
            modelElement = modelElements.stream().filter(Objects::nonNull).findAny().get();
        }
        ArrayList<EModelElement> rows = new ArrayList<EModelElement>();
        EModelElement sourceElement = null;
        EStructuralFeature feature = null;
        if (modelElement instanceof CompositeModelElement) {
            if (!((CompositeModelElement)modelElement).getSubElements().isEmpty()) {
                if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof UMLNotationModelElement) {
                    EModelElement eModelElement = ((UMLNotationModelElement)((CompositeModelElement)modelElement).getSubElements().get(0)).getEModelElement();
                    for (ModelElement subModelElement : ((CompositeModelElement)modelElement).getSubElements()) {
                        if (!(subModelElement instanceof UMLNotationModelElement)) continue;
                        rows.add(((UMLNotationModelElement)subModelElement).getEModelElement());
                    }
                    sourceElement = eModelElement;
                } else if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement) {
                    EMFModelElement emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                    sourceElement = emfModelElement.getSource();
                    feature = emfModelElement.getFeature(this.getLocalPropertyPath());
                }
            }
        } else if (modelElement instanceof UMLNotationModelElement) {
            EModelElement eModelElement = ((UMLNotationModelElement)modelElement).getEModelElement();
            rows.add(eModelElement);
            sourceElement = eModelElement;
        } else if (modelElement instanceof EMFModelElement) {
            Element baseElement;
            Element element;
            EMFModelElement emfModelElement = (EMFModelElement)modelElement;
            EObject source = emfModelElement.getSource();
            if (source != null && source instanceof HasSemantics) {
                if (((HasSemantics)source).getSemanticId() != null) {
                    source = ((HasSemantics)source).getSemanticId();
                } else {
                    element = UMLUtil.getBaseElement((EObject)source);
                    final HasSemantics has = (HasSemantics)source;
                    this.getOperationExecutor(element).execute(new Runnable(){

                        @Override
                        public void run() {
                            if (element instanceof Element) {
                                Model container = element.getModel();
                                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)container);
                                IElementType referenceElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
                                CreateElementRequest request = null;
                                request = new CreateElementRequest((TransactionalEditingDomain)domain, (EObject)container, referenceElementType);
                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
                                ICommand createReference = provider.getEditCommand((IEditCommandRequest)request);
                                if (createReference.canExecute()) {
                                    domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(createReference));
                                    Object result = createReference.getCommandResult().getReturnValue();
                                    Reference reference = AASNattablePropertyEditor.getReference(result);
                                    has.setSemanticId(reference);
                                } else {
                                    System.out.println("can not execute command");
                                }
                            }
                        }
                    }, "message");
                    source = ((HasSemantics)source).getSemanticId();
                }
            } else if (source != null && source instanceof ConceptDescription) {
                if (((ConceptDescription)source).getIsCaseOf() != null && !((ConceptDescription)source).getIsCaseOf().isEmpty()) {
                    source = (EObject)((ConceptDescription)source).getIsCaseOf().get(0);
                } else {
                    element = UMLUtil.getBaseElement((EObject)source);
                    final ConceptDescription cons = (ConceptDescription)source;
                    this.getOperationExecutor(element).execute(new Runnable(){

                        @Override
                        public void run() {
                            if (element instanceof Element) {
                                Model container = element.getModel();
                                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)container);
                                IElementType referenceElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
                                CreateElementRequest request = null;
                                request = new CreateElementRequest((TransactionalEditingDomain)domain, (EObject)container, referenceElementType);
                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
                                ICommand createReference = provider.getEditCommand((IEditCommandRequest)request);
                                if (createReference.canExecute()) {
                                    domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(createReference));
                                    Object result = createReference.getCommandResult().getReturnValue();
                                    Reference reference = AASNattablePropertyEditor.getReference(result);
                                    cons.getIsCaseOf().add((Object)reference);
                                } else {
                                    System.out.println("can not execute command");
                                }
                            }
                        }
                    }, "message");
                    source = (EObject)((ConceptDescription)source).getIsCaseOf().get(0);
                }
            }
            if (!(source instanceof Element) && (baseElement = UMLUtil.getBaseElement((EObject)source)) != null) {
                source = baseElement;
            }
            sourceElement = source;
            if (emfModelElement.getSource() instanceof HasSemantics) {
                feature = emfModelElement.getFeature("semanticId");
            } else if (emfModelElement.getSource() instanceof ConceptDescription) {
                feature = emfModelElement.getFeature("isCaseOf");
            }
        } else {
            this.displayError("Invalid table context");
            return;
        }
        this.createWidgets((EObject)sourceElement, feature, (Collection<?>)rows);
    }

    protected void createWidgets(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        this.createPreviousWidgets(sourceElement, feature);
        this.createTableWidget(sourceElement, feature, rows);
        this.createFollowingWidgets(sourceElement, feature);
        this.configureLayout(sourceElement);
        this.self.layout();
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
    }

    /*
     * Loose catch block
     */
    protected void createTableWidget(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        block15: {
            if (this.serviceRegistry == null) {
                try {
                    this.serviceRegistry = this.createServiceRegistry(sourceElement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.serviceRegistry == null) {
                this.displayError("Cannot initialize the service registry");
                return;
            }
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            if (domain == null) {
                this.displayError("Cannot found the editing domain");
                return;
            }
            this.table = this.getOrCreateTable(sourceElement, feature, rows);
            if (this.table == null) {
                this.displayError("Cannot initialize the table");
                return;
            }
            CompoundCommand cc = new CompoundCommand("Configure table command");
            if (this.table.eResource() == null) {
                cc.append(AASNattablePropertyEditor.addTableToResource(domain, this.resource, this.table));
            }
            this.configureTable(domain, this.table, sourceElement, feature, rows, cc);
            if (!cc.canExecute()) {
                this.displayError("The table can't be initialized");
                return;
            }
            ResourceSet resourceSet = this.getResourceSet();
            resourceSet.getResources().remove((Object)this.resource);
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)cc);
            }
            catch (InterruptedException interruptedException) {
                resourceSet.getResources().add((Object)this.resource);
                break block15;
            }
            catch (RollbackException rollbackException) {
                resourceSet.getResources().add((Object)this.resource);
                break block15;
                catch (Throwable throwable) {
                    resourceSet.getResources().add((Object)this.resource);
                    throw throwable;
                }
            }
            resourceSet.getResources().add((Object)this.resource);
        }
        if (this.table.getContext() == null) {
            this.displayError("The context of the table hasn't be set");
            return;
        }
        this.nattableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(this.table, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.natTableWidget = this.createNatTableWidget(this.nattableManager, (Composite)this.self, 0, rows);
        this.self.addDisposeListener(this.getDisposeListener());
        this.configureLayout();
        ((NattableModelManager)this.nattableManager).refreshNatTable();
    }

    protected void createFollowingWidgets(EObject sourceElement, EStructuralFeature feature) {
    }

    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        NatTable natTable = manager.createNattable((Composite)this.self, style, null);
        natTable.setBackground(this.self.getBackground());
        return natTable;
    }

    protected ServicesRegistry createServiceRegistry(EObject sourceElement) throws Exception {
        ServicesRegistry result = new ServicesRegistry();
        result.add(ModelSet.class, 10, (Object)new ModelSet());
        ServiceDescriptor desc = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        desc.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        desc.setClassBundleID("org.eclipse.papyrus.aas.ui");
        result.add(desc);
        result.startRegistry();
        return result;
    }

    @Deprecated
    protected void configureTreeTable(TreeNattableModelManager nattableManager, EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
    }

    @Deprecated
    protected void configureLayout() {
        GridData data = new GridData(4, 4, true, true);
        int headerHeight = this.natTableWidget.getPreferredHeight() - this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getPreferredHeight();
        int bodyHeight = this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getHeight();
        int extra = 36;
        data.minimumHeight = headerHeight + bodyHeight + 36;
        this.self.setLayoutData((Object)data);
        this.self.layout();
        this.natTableWidget.layout();
    }

    protected void configureLayout(EObject sourceElement) {
        ((NattableModelManager)this.nattableManager).refreshNatTable();
        this.configureSize(sourceElement);
        this.natTableWidget.layout();
    }

    protected void configureSize(EObject sourceElement) {
        GridData data = new GridData(4, 4, true, true);
        int headerHeight = this.natTableWidget.getPreferredHeight() - this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getPreferredHeight();
        int bodyHeight = this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getHeight();
        int extra = 36;
        data.minimumHeight = headerHeight + bodyHeight + 36;
        this.self.setLayoutData((Object)data);
    }

    protected void updateDescription(String description) {
        this.self.setToolTipText(description);
    }

    public void updateLabel(String label) {
        if (this.showLabel) {
            this.self.setText(this.getLabel());
        }
    }

    protected void displayError(String message) {
        CLabel label = new CLabel((Composite)this.self, 0);
        label.setText(message);
        label.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/error.gif"));
    }

    protected Table getOrCreateTable(EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows) {
        Table returnedTable = null;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        if (this.serviceRegistry != null) {
            URI tableURI = this.createTableURI(sourceElement, tableConfiguration);
            ResourceSet resourceSet = this.getResourceSet();
            TableResourceHelper.installTableSupport((ResourceSet)resourceSet);
            ((ModelSet)resourceSet).createModels(tableURI);
            boolean exists = resourceSet.getURIConverter().exists(tableURI, Collections.emptyMap());
            this.resource = exists ? resourceSet.getResource(tableURI, true) : resourceSet.createResource(tableURI);
            Iterator iter = this.resource.getContents().iterator();
            while (iter.hasNext() && returnedTable == null) {
                TableConfiguration configuration;
                EObject object = (EObject)iter.next();
                if (!(object instanceof Table) || (configuration = ((Table)object).getTableConfiguration()) == null || configuration.getType() == null || !configuration.getType().equals(this.getTableConfiguration().getType())) continue;
                returnedTable = (Table)object;
            }
            if (returnedTable == null) {
                returnedTable = this.createTable(sourceElement, synchronizedFeature);
            }
        }
        return returnedTable;
    }

    protected ResourceSet getResourceSet() {
        ResourceSet set = null;
        if (this.serviceRegistry != null) {
            try {
                set = (ResourceSet)this.serviceRegistry.getService(ModelSet.class);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return set;
    }

    protected URI createTableURI(EObject sourceElement, TableConfiguration tableConfiguration) {
        this.setRegisterTableConfigurationByEClass(sourceElement != null && sourceElement.eClass() != null);
        IPath preferencePath = InternalPlatform.getDefault().getStateLocation(Activator.getContext().getBundle(), true);
        preferencePath = preferencePath.append(TABLES_PREFERENCES_FOLDER_NAME).append(tableConfiguration.getType());
        StringBuilder b = new StringBuilder().append(preferencePath.toPortableString());
        if (this.registerTableConfigurationByEClass) {
            EObject source;
            ModelElement modelElement = this.input.getModelElement(this.propertyPath);
            EClass eClass = null;
            if (modelElement instanceof CompositeModelElement) {
                CompositeModelElement compoModelElement = (CompositeModelElement)modelElement;
                for (ModelElement next : compoModelElement.getSubElements()) {
                    if (!(next instanceof UMLNotationModelElement) && !(next instanceof EMFModelElement)) continue;
                    modelElement = next;
                    break;
                }
            }
            if (modelElement instanceof UMLNotationModelElement) {
                EditPart part = ((UMLNotationModelElement)modelElement).getEditPart();
                eClass = EMFHelper.getEObject((Object)part).eClass();
            } else if (modelElement instanceof EMFModelElement && (source = ((EMFModelElement)modelElement).getSource()) != null) {
                eClass = source.eClass();
            }
            if (eClass != null) {
                b.append("_");
                b.append(eClass.getName());
            }
        }
        URI newURI = URI.createFileURI((String)b.toString()).appendFileExtension(FILE_EXTENSION);
        return newURI;
    }

    protected Table createTable(EObject sourceElement, EStructuralFeature synchronizedFeature) {
        BooleanValueStyle expandStyle;
        BooleanValueStyle fillStyle;
        String description;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfiguration);
        Property property = this.getModelProperty();
        if (property != null && (description = property.getDescription()) != null) {
            table.setDescription(description);
        }
        table.setName(this.getLabel());
        table.setTableKindId(table.getTableConfiguration().getType());
        Object rowProvider = tableConfiguration.getDefaultRowAxisProvider();
        rowProvider = rowProvider == null ? NattableaxisproviderFactory.eINSTANCE.createMasterObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        Object columnProvider = tableConfiguration.getDefaultColumnAxisProvider();
        columnProvider = columnProvider == null ? NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        table.getColumnAxisProvidersHistory().add(columnProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add(rowProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        for (Style style : tableConfiguration.getStyles()) {
            table.getStyles().add((Object)((Style)EcoreUtil.copy((EObject)style)));
        }
        BooleanValueStyle columnsWidthAsPercentage = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
        if (columnsWidthAsPercentage == null && (fillStyle = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize")) == null) {
            columnsWidthAsPercentage = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            columnsWidthAsPercentage.setName("columnsWidthAsPercentage");
            columnsWidthAsPercentage.setBooleanValue(true);
            table.getStyles().add((Object)columnsWidthAsPercentage);
        }
        if ((expandStyle = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "expandAll")) == null) {
            expandStyle = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            expandStyle.setName("expandAll");
            expandStyle.setBooleanValue(true);
            table.getStyles().add((Object)expandStyle);
        }
        return table;
    }

    @Deprecated
    protected Table createTable(EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows) {
        String description;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfiguration);
        Property property = this.getModelProperty();
        if (property != null && (description = property.getDescription()) != null) {
            table.setDescription(description);
        }
        table.setName(this.getLabel());
        Object rowProvider = tableConfiguration.getDefaultRowAxisProvider();
        rowProvider = rowProvider == null ? NattableaxisproviderFactory.eINSTANCE.createMasterObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        Object columnProvider = tableConfiguration.getDefaultColumnAxisProvider();
        columnProvider = columnProvider == null ? NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        if (synchronizedFeature != null) {
            TableHeaderAxisConfiguration rowHeaderAxisconfig = tableConfiguration.getRowHeaderAxisConfiguration();
            for (IAxisConfiguration axisConfig : rowHeaderAxisconfig.getOwnedAxisConfigurations()) {
                if (!(axisConfig instanceof EStructuralFeatureValueFillingConfiguration)) continue;
                ((EStructuralFeatureValueFillingConfiguration)axisConfig).setListenFeature(synchronizedFeature);
            }
        }
        table.getColumnAxisProvidersHistory().add(columnProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add(rowProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        for (Style style : tableConfiguration.getStyles()) {
            table.getStyles().add((Object)((Style)EcoreUtil.copy((EObject)style)));
        }
        return table;
    }

    protected TransactionalEditingDomain getTableEditingDomain() {
        try {
            return (TransactionalEditingDomain)this.serviceRegistry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    protected TableConfiguration getTableConfiguration() {
        ResourceSet resourceSet;
        if (this.tableConfiguration == null && (resourceSet = this.getResourceSet()) != null) {
            try {
                this.tableConfiguration = (TableConfiguration)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)this.tableConfigURI);
            }
            catch (Exception ex) {
                Activator.log.error("Invalid table configuration", (Throwable)ex);
            }
        }
        return this.tableConfiguration;
    }

    protected DisposeListener getDisposeListener() {
        if (this.nattableDisposeListener == null) {
            this.nattableDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AASNattablePropertyEditor.this.disposeListener();
                }
            };
        }
        return this.nattableDisposeListener;
    }

    protected void disposeListener() {
        if (this.serviceRegistry != null) {
            if (this.nattableManager != null) {
                this.nattableManager.dispose();
            }
            if (this.natTableWidget != null) {
                this.natTableWidget.dispose();
            }
            if (this.resource != null) {
                try {
                    this.resource.save(null);
                }
                catch (IOException e1) {
                    Activator.log.error((Throwable)e1);
                }
            }
            try {
                this.serviceRegistry.disposeRegistry();
            }
            catch (ServiceMultiException e1) {
                Activator.log.error((Throwable)e1);
            }
            this.serviceRegistry = null;
            this.table = null;
        }
    }

    @Deprecated
    protected CompoundCommand getDisposeTableCommand(TransactionalEditingDomain domain, Table table) {
        CompoundCommand disposeCommand = new CompoundCommand("Command used to clean the table before disposing it");
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Context(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Owner(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table.getCurrentRowAxisProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.emptyList()));
        return disposeCommand;
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    public static Reference getReference(Object result) {
        Reference ref = null;
        if (result != null) {
            ref = (Reference)UMLUtil.getStereotypeApplication((Element)((Element)result), Reference.class);
        }
        return ref;
    }

    public static ConceptDescription getConceptDescription(EObject sourceElement) {
        ConceptDescription conceptDescription = null;
        if (sourceElement != null && sourceElement instanceof Element) {
            conceptDescription = (ConceptDescription)UMLUtil.getStereotypeApplication((Element)((Element)sourceElement), ConceptDescription.class);
        }
        return conceptDescription;
    }

    public static HasSemantics gethasSemantic(EObject sourceElement) {
        HasSemantics HasSem = null;
        if (sourceElement != null && sourceElement instanceof Element) {
            HasSem = (HasSemantics)UMLUtil.getStereotypeApplication((Element)((Element)sourceElement), HasSemantics.class);
        }
        return HasSem;
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                public void dataSourceChanged(DataSourceChangedEvent event) {
                    block23: {
                        EStructuralFeature feature;
                        ModelElement modelElement;
                        EObject sourceElement;
                        ArrayList contexts;
                        block24: {
                            EMFModelElement emfModelElement;
                            block25: {
                                AASNattablePropertyEditor.this.disposeListener();
                                if (AASNattablePropertyEditor.this.self != null) {
                                    if (AASNattablePropertyEditor.this.self.getChildren().length > 0) {
                                        Control[] controlArray = AASNattablePropertyEditor.this.self.getChildren();
                                        int n = controlArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Control control = controlArray[n2];
                                            control.dispose();
                                            ++n2;
                                        }
                                    }
                                    AASNattablePropertyEditor.this.self.removeDisposeListener(AASNattablePropertyEditor.this.getDisposeListener());
                                    AASNattablePropertyEditor.this.nattableDisposeListener = null;
                                    AASNattablePropertyEditor.this.self.layout();
                                }
                                DataSource dataSource = event.getDataSource();
                                StructuredSelection selection = (StructuredSelection)dataSource.getSelection();
                                contexts = new ArrayList(selection.size());
                                sourceElement = null;
                                for (Object selectedObject : selection) {
                                    boolean cfr_ignored_0 = selectedObject instanceof AbstractEditPart;
                                    if (sourceElement != null) continue;
                                    sourceElement = EMFHelper.getEObject(selectedObject);
                                }
                                if (sourceElement == null) break block23;
                                modelElement = null;
                                if (AASNattablePropertyEditor.gethasSemantic(sourceElement) != null) {
                                    modelElement = dataSource.getModelElement("AAS:HasSemantics:semanticId");
                                } else if (AASNattablePropertyEditor.getConceptDescription(sourceElement) != null) {
                                    modelElement = dataSource.getModelElement("AAS:ConceptDescription:isCaseOf");
                                }
                                sourceElement = AASNattablePropertyEditor.this.getEObjectAsTableContext(sourceElement);
                                feature = null;
                                if (!(modelElement instanceof CompositeModelElement)) break block24;
                                if (((CompositeModelElement)modelElement).getSubElements().isEmpty() || !(((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement)) break block23;
                                emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                                if (!(emfModelElement instanceof HasSemantics)) break block25;
                                feature = emfModelElement.getFeature("semanticId");
                                break block23;
                            }
                            if (!(emfModelElement instanceof ConceptDescription)) break block23;
                            feature = emfModelElement.getFeature("isCaseOf");
                            break block23;
                        }
                        if (modelElement instanceof EMFModelElement) {
                            Element baseElement;
                            EMFModelElement emfModelElement = (EMFModelElement)modelElement;
                            if (sourceElement != null && AASNattablePropertyEditor.gethasSemantic(sourceElement) != null) {
                                if (AASNattablePropertyEditor.gethasSemantic(sourceElement).getSemanticId() != null) {
                                    sourceElement = AASNattablePropertyEditor.gethasSemantic(sourceElement).getSemanticId();
                                }
                            } else if (sourceElement != null && AASNattablePropertyEditor.getConceptDescription(sourceElement) != null && AASNattablePropertyEditor.getConceptDescription(sourceElement).getIsCaseOf() != null && AASNattablePropertyEditor.getConceptDescription(sourceElement).getIsCaseOf().isEmpty()) {
                                sourceElement = (EObject)AASNattablePropertyEditor.getConceptDescription(sourceElement).getIsCaseOf().get(0);
                            }
                            if (!(sourceElement instanceof Element) && (baseElement = UMLUtil.getBaseElement((EObject)sourceElement)) != null) {
                                sourceElement = baseElement;
                            }
                            if (AASNattablePropertyEditor.gethasSemantic(sourceElement) != null || AASNattablePropertyEditor.getConceptDescription(sourceElement) != null) {
                                Element element;
                                final HasSemantics has = AASNattablePropertyEditor.gethasSemantic(sourceElement);
                                final ConceptDescription cons = AASNattablePropertyEditor.getConceptDescription(sourceElement);
                                if (has != null && has.getSemanticId() == null) {
                                    element = (Element)sourceElement;
                                    AASNattablePropertyEditor.this.getOperationExecutor(element).execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (element instanceof Element) {
                                                Model container = element.getModel();
                                                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)container);
                                                IElementType referenceElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
                                                CreateElementRequest request = null;
                                                request = new CreateElementRequest((TransactionalEditingDomain)domain, (EObject)container, referenceElementType);
                                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
                                                ICommand createReference = provider.getEditCommand((IEditCommandRequest)request);
                                                if (createReference.canExecute()) {
                                                    domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(createReference));
                                                    Object result = createReference.getCommandResult().getReturnValue();
                                                    Reference reference = AASNattablePropertyEditor.getReference(result);
                                                    has.setSemanticId(reference);
                                                } else {
                                                    System.out.println("can not execute command");
                                                }
                                            }
                                        }
                                    }, "message");
                                } else if (cons != null && (cons.getIsCaseOf() == null || cons.getIsCaseOf().isEmpty())) {
                                    element = (Element)sourceElement;
                                    AASNattablePropertyEditor.this.getOperationExecutor(element).execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (element instanceof Element) {
                                                Model container = element.getModel();
                                                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)container);
                                                IElementType referenceElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
                                                CreateElementRequest request = null;
                                                request = new CreateElementRequest((TransactionalEditingDomain)domain, (EObject)container, referenceElementType);
                                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
                                                ICommand createReference = provider.getEditCommand((IEditCommandRequest)request);
                                                if (createReference.canExecute()) {
                                                    domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(createReference));
                                                    Object result = createReference.getCommandResult().getReturnValue();
                                                    Reference reference = AASNattablePropertyEditor.getReference(result);
                                                    cons.getIsCaseOf().add((Object)reference);
                                                } else {
                                                    System.out.println("can not execute command");
                                                }
                                            }
                                        }
                                    }, "message");
                                }
                                if (has != null) {
                                    sourceElement = UMLUtil.getBaseElement((EObject)has.getSemanticId());
                                    feature = emfModelElement.getFeature("semanticId");
                                } else if (cons != null) {
                                    sourceElement = UMLUtil.getBaseElement((EObject)((EObject)cons.getIsCaseOf().get(0)));
                                    feature = emfModelElement.getFeature("isCaseOf");
                                }
                            }
                            AASNattablePropertyEditor.this.createWidgets(sourceElement, feature, contexts);
                            Composite parent = AASNattablePropertyEditor.this.self.getParent();
                            boolean found = false;
                            while (parent != null && !found) {
                                if (parent instanceof TabbedPropertyComposite) {
                                    found = true;
                                } else {
                                    parent.layout(true, true);
                                    parent.redraw();
                                    parent.update();
                                }
                                parent = parent.getParent();
                            }
                        }
                    }
                }
            };
        }
        return this.dataSourceListener;
    }

    protected EObject getEObjectAsTableContext(EObject element) {
        EObject result = element;
        if (result instanceof View) {
            result = ((View)result).getElement();
        }
        return result;
    }

    private static final Command addTableToResource(TransactionalEditingDomain domain, final Resource resource, final Table table) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                resource.getContents().add((Object)table);
            }
        };
    }

    protected void configureTable(TransactionalEditingDomain domain, Table table, EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows, CompoundCommand command) {
        Assert.isNotNull((Object)domain);
        Command setContextCommand = SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Context(), (Object)sourceElement);
        command.append(setContextCommand);
        if (TableHelper.isTreeTable((Table)table) && rows != null && !rows.isEmpty()) {
            AbstractAxisProvider axisProvider = table.getCurrentRowAxisProvider();
            TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration((Table)table);
            AxisManagerRepresentation rep = (AxisManagerRepresentation)conf.getAxisManagers().get(0);
            for (Object context : rows) {
                this.addTreeItemAxis(domain, axisProvider, rep, context, command);
            }
        }
    }

    protected void addTreeItemAxis(TransactionalEditingDomain domain, AbstractAxisProvider axisProvider, AxisManagerRepresentation rep, Object object, CompoundCommand command) {
        ITreeItemAxis axis = ITreeItemAxisHelper.createITreeItemAxis(null, null, (Object)object, (AxisManagerRepresentation)rep);
        Command addCommand = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)axisProvider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.singleton(axis));
        command.append(addCommand);
    }

    public IAtomicOperationExecutor getOperationExecutor(Object context) {
        IAtomicOperationExecutor result = context instanceof IAdaptable ? (IAtomicOperationExecutor)((IAdaptable)context).getAdapter(IAtomicOperationExecutor.class) : (context != null ? (IAtomicOperationExecutor)Platform.getAdapterManager().getAdapter(context, IAtomicOperationExecutor.class) : null);
        if (result == null) {
            result = IAtomicOperationExecutor.DEFAULT;
        }
        return result;
    }
}

