/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.profile.ui.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.commands.IModelConversionCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;

public class UMLtoAASModelConversionCommand
implements IModelConversionCommand {
    public void convertModel(ModelSet modelSet) {
        NotationModel model = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        CompositeCommand compositeCommand = new CompositeCommand("Conversion to SysML 1.6 context");
        for (Resource current : model.getResources()) {
            for (EObject element : current.getContents()) {
                if (!(element instanceof Diagram)) continue;
                ICommand convertDiagram = this.convertDiagram((Diagram)element);
                compositeCommand.add((IUndoableOperation)convertDiagram);
            }
        }
        try {
            GMFUnsafe.write((TransactionalEditingDomain)modelSet.getTransactionalEditingDomain(), (ICommand)compositeCommand);
        }
        catch (InterruptedException | ExecutionException | RollbackException e) {
            e.printStackTrace();
        }
    }

    public ICommand convertDiagram(Diagram diagram) {
        for (Object object : diagram.getStyles()) {
            if (!(object instanceof PapyrusDiagramStyle)) continue;
            switch (((PapyrusDiagramStyle)object).getDiagramKindId()) {
                case "org.eclipse.papyrus.uml.diagram.class": {
                    return new SetPapyrusDiagramStyleCommand(diagram, "org.eclipse.papyrus.aas.design.diagram");
                }
            }
        }
        return IdentityCommand.INSTANCE;
    }

    private class SetPapyrusDiagramStyleCommand
    extends AbstractCommand {
        private Diagram diagram;
        private String diagramKind;

        public SetPapyrusDiagramStyleCommand(Diagram diagram, String newStyle) {
            super("Set new diagram kind for Papyrus Style");
            this.diagram = diagram;
            this.diagramKind = newStyle;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            for (Object object : this.diagram.getStyles()) {
                if (!(object instanceof PapyrusDiagramStyle)) continue;
                ((PapyrusDiagramStyle)object).setDiagramKindId(this.diagramKind);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

