/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.profile.ui.advices;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.aas.Submodel;
import org.eclipse.papyrus.aas.profile.ui.advices.ElementConfigurationCommand;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SubModelEditHelperAdvice
extends AbstractEditHelperAdvice {
    public ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final EObject newElement = request.getElementToConfigure();
        final EObject container = newElement.eContainer();
        final TransactionalEditingDomain domain = request.getEditingDomain();
        if (container != null) {
            if (container instanceof Class) {
                return new ConfigureElementCommand(request){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        Object result;
                        Model model = ((Element)container).getModel();
                        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)((Element)container), AssetAdministrationShell.class);
                        Submodel submodel = (Submodel)UMLUtil.getStereotypeApplication((Element)((Element)newElement), Submodel.class);
                        IElementType referenceElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
                        CreateElementRequest request2 = new CreateElementRequest(domain, (EObject)model, referenceElementType);
                        IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((EObject)model);
                        ICommand command = provider2.getEditCommand((IEditCommandRequest)request2);
                        if (command != null && command.canExecute()) {
                            try {
                                command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((result = command.getCommandResult().getReturnValue()) != null) {
                            Reference ref = SubModelEditHelperAdvice.getReference((Element)result);
                            submodel.setSemanticId(ref);
                        }
                        return CommandResult.newOKCommandResult((Object)newElement);
                    }
                };
            }
            if (container instanceof Package || container instanceof Model) {
                return new ElementConfigurationCommand(request);
            }
        }
        return super.getAfterConfigureCommand(request);
    }

    public static Reference getReference(Element element) {
        Reference conceptDescription = null;
        if (element != null) {
            conceptDescription = (Reference)UMLUtil.getStereotypeApplication((Element)element, Reference.class);
        }
        return conceptDescription;
    }
}

