/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum KeyType implements Enumerator
{
    CUSTOM(0, "Custom", "Custom"),
    IRDI(1, "IRDI", "IRDI"),
    IRI(2, "IRI", "IRI"),
    ID_SHORT(3, "IdShort", "IdShort"),
    FRAGMENT_ID(4, "FragmentId", "FragmentId");

    public static final int CUSTOM_VALUE = 0;
    public static final int IRDI_VALUE = 1;
    public static final int IRI_VALUE = 2;
    public static final int ID_SHORT_VALUE = 3;
    public static final int FRAGMENT_ID_VALUE = 4;
    private static final KeyType[] VALUES_ARRAY;
    public static final List<KeyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new KeyType[]{CUSTOM, IRDI, IRI, ID_SHORT, FRAGMENT_ID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static KeyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KeyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KeyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KeyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KeyType get(int value) {
        switch (value) {
            case 0: {
                return CUSTOM;
            }
            case 1: {
                return IRDI;
            }
            case 2: {
                return IRI;
            }
            case 3: {
                return ID_SHORT;
            }
            case 4: {
                return FRAGMENT_ID;
            }
        }
        return null;
    }

    private KeyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

