/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EntityType implements Enumerator
{
    CO_MANAGED_ENTITY(0, "CoManagedEntity", "CoManagedEntity"),
    SELF_MANAGED_ENTITY(1, "SelfManagedEntity", "SelfManagedEntity");

    public static final int CO_MANAGED_ENTITY_VALUE = 0;
    public static final int SELF_MANAGED_ENTITY_VALUE = 1;
    private static final EntityType[] VALUES_ARRAY;
    public static final List<EntityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityType[]{CO_MANAGED_ENTITY, SELF_MANAGED_ENTITY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityType get(int value) {
        switch (value) {
            case 0: {
                return CO_MANAGED_ENTITY;
            }
            case 1: {
                return SELF_MANAGED_ENTITY;
            }
        }
        return null;
    }

    private EntityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

