/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.codegen.ui.handlers;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.eclipse.aas.basyx.codegen.generator.Project;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.papyrus.aas.codegen.ui.handlers.GenerateAASCodeHelper;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class GenerateAASCodeHandler
extends CmdHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Generating Basyx Code...", -1);
                try {
                    GenerateAASCodeHandler.this.executeCodeGen(monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageDialog.openError((Shell)GenerateAASCodeHelper.getShell(), (String)"Error", (String)("Error During Code generation" + (e.getMessage() != null ? e.getMessage() : e.toString())));
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, op);
            MessageDialog.openInformation((Shell)GenerateAASCodeHelper.getShell(), (String)"Success", (String)("The project " + ((Class)this.selectedEObject).getName() + " has been successfully generated and imported into your workspace"));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)GenerateAASCodeHelper.getShell(), (String)"Error", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)GenerateAASCodeHelper.getShell(), (String)"Error", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)GenerateAASCodeHelper.getShell(), (String)"Error", (String)(e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return null;
    }

    private Object executeCodeGen(IProgressMonitor monitor) throws Exception {
        Class selectedClass = (Class)this.selectedEObject;
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)selectedClass, AssetAdministrationShell.class);
        if (aas != null) {
            URI uri = selectedClass.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() < 2) {
                return null;
            }
            String projectLocation = uri.segment(1);
            try {
                projectLocation = URLDecoder.decode(uri.segment(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            IProject modelProject = root.getProject(projectLocation);
            if (modelProject.exists()) {
                org.eclipse.aas.api.aas.AssetAdministrationShell basyxAAS = GenerateAASCodeHelper.getAAS(selectedClass);
                String projectName = selectedClass.getName() != null ? selectedClass.getName() : "BaSyxAAS";
                Project aasproject = new Project(basyxAAS);
                aasproject.setProjectName(projectName);
                aasproject.setNamespaceFromProjectName();
                aasproject.setProjectFolder(String.valueOf(root.getLocation().toString()) + "/" + projectName + "/");
                aasproject.createProject();
                try {
                    IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(root.getLocation().toString()) + "/" + selectedClass.getName() + "/.project"));
                    File pomFile = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/" + selectedClass.getName() + "/pom.xml");
                    this.importMavenProjects(monitor, pomFile, description.getName(), "aas", "aasmodule", "0.1");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                Pattern java = Pattern.compile("Java");
                ILangCodegen javaCodeGen = LanguageCodegen.getGenerator((Pattern)java, null);
                IProject generatedProject = root.getProject(projectName);
                if (GenerateAASCodeHelper.getUMLSubmodels(selectedClass) != null && !GenerateAASCodeHelper.getUMLSubmodels(selectedClass).isEmpty()) {
                    for (Class submodelClass : GenerateAASCodeHelper.getUMLSubmodels(selectedClass)) {
                        this.generate(javaCodeGen, generatedProject, (PackageableElement)submodelClass, (EList<PackageableElement>)new BasicEList(), false);
                    }
                }
            }
        }
        return null;
    }

    public void generate(ILangCodegen codeGen, IProject genProject, PackageableElement pe, EList<PackageableElement> alreadyHandled, boolean recurse) {
        alreadyHandled.add((Object)pe);
        codeGen.generateCode(genProject, pe, null);
    }

    private void importMavenProjects(IProgressMonitor monitor, File pomFile, String projectName, String groupId, String artifactId, String version) throws CoreException {
        IProjectConfigurationManager manager = MavenPlugin.getProjectConfigurationManager();
        ProjectImportConfiguration config = new ProjectImportConfiguration();
        ArrayList<MavenProjectInfo> infos = new ArrayList<MavenProjectInfo>();
        Model model = new Model();
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(version);
        model.setPomFile(pomFile);
        MavenProjectInfo info = new MavenProjectInfo(projectName, pomFile, model, null);
        infos.add(info);
        manager.importProjects(infos, config, monitor);
    }
}

