/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements;

import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.IOperationVariable;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGenerator {
    private static final Logger logger = LoggerFactory.getLogger(OperationGenerator.class);
    private Operation opInstance;
    private List<IOperationVariable> inputVariables;
    private List<IOperationVariable> inoutputVariables;
    private List<IOperationVariable> outputVariables;
    private List<Key> semanticKeys;
    private String parent;
    private ConceptDescription conceptDesc;

    public OperationGenerator(Operation opInstance) {
        this.opInstance = opInstance;
        this.inputVariables = opInstance.getInputVars();
        this.inoutputVariables = opInstance.getInoutputVars();
        this.outputVariables = opInstance.getOutputVars();
        try {
            this.semanticKeys = opInstance.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        try {
            this.conceptDesc = this.opInstance.getSemanticDescription();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception while fetching ConceptDescription for the semantic Id definition of the Operation: " + this.getClass().getSimpleName());
        }
        if (opInstance.getParentSEC() != null) {
            this.parent = opInstance.getParentSEC().getIdShort();
        } else if (opInstance.getParentSub() != null) {
            this.parent = opInstance.getParentSub().getIdShort();
        } else {
            logger.error("Operation: " + opInstance.getIdShort() + "has no Parent defined");
        }
        logger.info("OperationGenerator Initialised for Operation : " + opInstance.getIdShort());
    }

    public String generateOperation() {
        String opText = String.valueOf(this.generateLambdaContent()) + "\t\tOperation " + this.parent + "_" + this.opInstance.getIdShort() + "= new Operation();\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setIdShort(\"" + this.opInstance.getIdShort() + "\");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setInvokable(call" + this.parent + "_" + this.opInstance.getIdShort() + ");\r\n" + this.generateModelingInfo() + this.generateSemanticReference() + this.generateParentalRelation() + "\r\n" + this.generateInputVariables() + "\r\n" + this.generateInOutputVariables() + "\r\n" + this.generateOutputVariables() + "\r\n\r\n";
        logger.info("Operation Code generated for Operation: " + this.opInstance.getIdShort());
        return opText;
    }

    public String generateOperationFieldVariables() {
        String fieldOpVar = "";
        if (!this.inputVariables.isEmpty()) {
            for (IOperationVariable inputVariable : this.inputVariables) {
                fieldOpVar = String.valueOf(fieldOpVar) + "\tprotected static Property " + this.parent + "_" + inputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Input" + " = new Property(\"" + inputVariable.getValue().getIdShort() + "\", ValueType." + inputVariable.getValueType() + ");\r\n";
            }
            fieldOpVar = String.valueOf(fieldOpVar) + "\t\t\r\n\r\n";
            logger.info("Input Variables as Field for Operation: " + this.opInstance.getIdShort() + " generated.");
        } else {
            logger.debug("No Input Variables found for Operation: " + this.opInstance.getIdShort() + ". Or an exception has occured.");
        }
        if (!this.inoutputVariables.isEmpty()) {
            for (IOperationVariable inoutputVariable : this.inoutputVariables) {
                fieldOpVar = String.valueOf(fieldOpVar) + "\tprotected static Property " + this.parent + "_" + inoutputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "InOutput" + " = new Property(\"" + inoutputVariable.getValue().getIdShort() + "\", ValueType." + inoutputVariable.getValueType() + ");\r\n";
            }
            fieldOpVar = String.valueOf(fieldOpVar) + "\t\t\r\n\r\n";
            logger.info("Inoutput Variables as Field for Operation: " + this.opInstance.getIdShort() + " generated.");
        } else {
            logger.debug("No Inoutput Variables found for Operation: " + this.opInstance.getIdShort() + ". Or an exception has occured.");
        }
        if (!this.outputVariables.isEmpty()) {
            for (IOperationVariable outputVariable : this.outputVariables) {
                fieldOpVar = String.valueOf(fieldOpVar) + "\tprotected static Property " + this.parent + "_" + outputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Output" + " = new Property(\"" + outputVariable.getValue().getIdShort() + "\", ValueType." + outputVariable.getValueType() + ");\r\n";
            }
            fieldOpVar = String.valueOf(fieldOpVar) + "\t\t\r\n\r\n";
            logger.info("Output Variables as Field for Operation: " + this.opInstance.getIdShort() + " generated.");
        } else {
            logger.debug("No Output Variables found for Operation: " + this.opInstance.getIdShort() + ". Or an exception has occured.");
        }
        return fieldOpVar;
    }

    private String generateLambdaContent() {
        String lambdaFuncBody = "";
        String argsFormulation = "";
        if (!this.inputVariables.isEmpty()) {
            int varcount = 0;
            for (IOperationVariable inputVariable : this.inputVariables) {
                lambdaFuncBody = String.valueOf(lambdaFuncBody) + "\t\t\t" + this.parent + "_" + inputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Input" + ".setValue((" + "arguments[" + varcount + "]" + "));\r\n";
                argsFormulation = String.valueOf(argsFormulation) + "(" + this.convertBaSyxToJavaTypes(inputVariable.getValueType()) + ") " + this.parent + "_" + inputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Input" + ".getValue()" + ",";
                ++varcount;
            }
            if (argsFormulation != null && argsFormulation.length() > 0 && argsFormulation.charAt(argsFormulation.length() - 1) == ',') {
                argsFormulation = argsFormulation.substring(0, argsFormulation.length() - 1);
            }
        } else {
            logger.debug("No InputVariables found for Operation: " + this.opInstance.getIdShort());
        }
        String lambdaFuncReturn = "";
        lambdaFuncReturn = !this.inputVariables.isEmpty() ? (this.outputVariables.isEmpty() ? "\t\t\tdew." + this.parent + "_" + this.opInstance.getIdShort() + "(" + argsFormulation + ");\r\n" + "\t\t\treturn null;\r\n" : "\t\t\treturn dew." + this.parent + "_" + this.opInstance.getIdShort() + "(" + argsFormulation + ");\r\n") : (this.outputVariables.isEmpty() ? "\t\t\tdew." + this.parent + "_" + this.opInstance.getIdShort() + "();\r\n" + "\t\t\treturn null;\r\n" : "\t\t\treturn dew." + this.parent + "_" + this.opInstance.getIdShort() + "();\r\n");
        String lambdaFuncContent = String.valueOf(lambdaFuncBody) + lambdaFuncReturn;
        String lambdaFunc = "\t\tFunction<Object[], Object> call" + this.parent + "_" + this.opInstance.getIdShort() + " = (arguments) -> " + "{\r\n" + "\r\n" + lambdaFuncContent + "\r\n\t\t};\r\n";
        return lambdaFunc;
    }

    private String generateInputVariables() {
        String inputVariablesText = "\t\tCollection<OperationVariable> " + this.parent + "_" + this.opInstance.getIdShort() + "Input" + "s = new ArrayList<OperationVariable>();\r\n";
        if (!this.inputVariables.isEmpty()) {
            for (IOperationVariable inputVariable : this.inputVariables) {
                inputVariablesText = String.valueOf(inputVariablesText) + "\t\tOperationVariable " + this.parent + "_" + inputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + " = new OperationVariable();\r\n" + "\t\t" + this.parent + "_" + inputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Input" + "." + "setKind(ModelingKind." + inputVariable.getValue().getKind() + ");\r\n" + "\t\t" + this.parent + "_" + inputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ".setValue(" + this.parent + "_" + inputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Input" + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + "Input" + "s.add(" + this.parent + "_" + inputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setInputVariables(" + this.parent + "_" + this.opInstance.getIdShort() + "Input" + "s" + "); \r\n";
            }
        } else {
            inputVariablesText = "";
        }
        return inputVariablesText;
    }

    private String generateInOutputVariables() {
        String inoutputVariablesText = "\t\tCollection<OperationVariable> " + this.parent + "_" + this.opInstance.getIdShort() + "InOutput" + "s = new ArrayList<OperationVariable>();\r\n";
        if (!this.inoutputVariables.isEmpty()) {
            for (IOperationVariable inoutputVariable : this.inoutputVariables) {
                inoutputVariablesText = String.valueOf(inoutputVariablesText) + "\t\tOperationVariable " + this.parent + "_" + inoutputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + " = new OperationVariable();\r\n" + "\t\t" + this.parent + "_" + inoutputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "InOutput" + "." + "setKind(ModelingKind." + inoutputVariable.getValue().getKind() + ");\r\n" + "\t\t" + this.parent + "_" + inoutputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ".setValue(" + this.parent + "_" + inoutputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "InOutput" + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + "InOutput" + "s.add(" + this.parent + "_" + inoutputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setInOutputVariables(" + this.parent + "_" + this.opInstance.getIdShort() + "InOutput" + "s" + "); \r\n";
            }
        } else {
            inoutputVariablesText = "";
        }
        return inoutputVariablesText;
    }

    private String generateOutputVariables() {
        String outputVariablesText = "\t\tCollection<OperationVariable> " + this.parent + "_" + this.opInstance.getIdShort() + "Output" + "s = new ArrayList<OperationVariable>();\r\n";
        if (!this.outputVariables.isEmpty()) {
            for (IOperationVariable outputVariable : this.outputVariables) {
                outputVariablesText = String.valueOf(outputVariablesText) + "\t\tOperationVariable " + this.parent + "_" + outputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + " = new OperationVariable();\r\n" + "\t\t" + this.parent + "_" + outputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Output" + "." + "setKind(ModelingKind." + outputVariable.getValue().getKind() + ");\r\n" + "\t\t" + this.parent + "_" + outputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ".setValue(" + this.parent + "_" + outputVariable.getValue().getIdShort() + "_" + this.opInstance.getIdShort() + "_" + "Output" + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + "Output" + "s.add(" + this.parent + "_" + outputVariable.getValue().getIdShort() + this.opInstance.getIdShort() + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setOutputVariables(" + this.parent + "_" + this.opInstance.getIdShort() + "Output" + "s" + "); \r\n";
            }
        } else {
            outputVariablesText = "";
        }
        return outputVariablesText;
    }

    private String generateModelingInfo() {
        String setKind = "";
        if (this.opInstance.getKind() != null) {
            setKind = "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setKind(ModelingKind." + this.opInstance.getKind() + ");\r\n";
            logger.info("Generated ModelingKind Info for Operation: " + this.opInstance.getIdShort());
        } else {
            logger.info("Generated ModelingKind Info for Operation: " + this.opInstance.getIdShort() + " not generated.");
        }
        return setKind;
    }

    private String generateParentalRelation() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isSubModelOperation = true;
        if (stackTraceElements[3].getMethodName() == "generateSubModelElementCollection") {
            isSubModelOperation = false;
        }
        String addOperation = "";
        if (isSubModelOperation) {
            addOperation = "\t\taddSubmodelElement(" + this.parent + "_" + this.opInstance.getIdShort() + ");\r\n";
        } else {
            SubModelElementCollection parentSEC = this.opInstance.getParentSEC();
            String immediateParent = "";
            if (parentSEC.getParentSEC() != null) {
                immediateParent = parentSEC.getParentSEC().getIdShort();
            } else if (parentSEC.getParentSub() != null) {
                immediateParent = parentSEC.getParentSub().getIdShort();
            } else {
                logger.error("SubModelElementCollection: " + parentSEC.getIdShort() + "has no Parent defined");
            }
            addOperation = "\t\t" + immediateParent + "_" + parentSEC.getIdShort() + "value.add(" + this.parent + "_" + this.opInstance.getIdShort() + ");\r\n\r\n";
        }
        return addOperation;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.parent + "_" + this.opInstance.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.opInstance.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.parent + "_" + this.opInstance.getIdShort() + "Ref = new Reference(" + this.parent + "_" + this.opInstance.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setSemanticId(" + this.parent + "_" + this.opInstance.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for Operation: " + this.opInstance.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.opInstance.getIdShort() + ".setSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for Operation: " + this.opInstance.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }

    private String convertBaSyxToJavaTypes(String valueType) {
        switch (valueType) {
            case "Int8": {
                return "Byte";
            }
            case "Int16": 
            case "UInt8": {
                return "Short";
            }
            case "UInt16": 
            case "Integer": 
            case "Int32": {
                return "Integer";
            }
            case "NonPositiveInteger": 
            case "NonNegativeInteger": 
            case "PositiveInteger": 
            case "NegativeInteger": {
                return "BigInteger";
            }
            case "UInt32": 
            case "Int64": {
                return "Long";
            }
            case "UInt64": {
                return "BigInteger";
            }
            case "Double": {
                return "Double";
            }
            case "Float": {
                return "Float";
            }
            case "Boolean": {
                return "Boolean";
            }
            case "String": {
                return "String";
            }
            case "Duration": 
            case "DayTimeDuration": {
                return "Duration";
            }
            case "YearMonthDuration": {
                return "Duration";
            }
            case "QName": {
                return "QName";
            }
            case "NOTATION": {
                return "QName";
            }
            case "AnyURI": {
                return "String";
            }
            case "LangString": {
                return "LangString";
            }
            case "Base64Binary": 
            case "HexBinary": {
                return "Byte[]";
            }
            case "GDay": 
            case "GYear": 
            case "GMonthDay": 
            case "GYearMonth": 
            case "DateTime": 
            case "GMonth": {
                return "XMLGregorianCalendar";
            }
            case "DateTimeStamp": 
            case "ID": 
            case "None": 
            case "IDREF": 
            case "AnyType": 
            case "AnySimpleType": 
            case "ENTITY": {
                return "String";
            }
        }
        return "Object";
    }
}

