/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.FileGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.MLPGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.OperationGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.PropertyGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.SECGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubModelCreator {
    private static final Logger logger = LoggerFactory.getLogger(SubModelCreator.class);
    private int year = Calendar.getInstance().get(1);
    private SubModel subModel;
    private String nameSpace;
    private List<Property> properties;
    private List<File> files;
    private List<Operation> operations;
    private List<MultiLanguageProperty> multiLanguageProperties;
    private List<SubModelElementCollection> subModelElementCollections;
    private List<Key> semanticKeys;
    private ConceptDescription conceptDesc;

    public SubModelCreator(SubModel subModel, String nameSpace) {
        this.subModel = subModel;
        this.nameSpace = nameSpace;
        this.properties = this.subModel.getProperties();
        this.files = this.subModel.getFiles();
        this.operations = this.subModel.getOperations();
        this.multiLanguageProperties = this.subModel.getMultiLanguageProperties();
        this.subModelElementCollections = this.subModel.getSubModelElementCollections();
        try {
            this.semanticKeys = this.subModel.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        try {
            this.conceptDesc = this.subModel.getSemanticDescription();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception while fetching ConceptDescription for the semantic Id definition of the SubModel: " + this.getClass().getSimpleName());
        }
        logger.info("SubModelCreator Initialised for SubModel : " + subModel.getIdShort() + " in namespace: " + nameSpace);
    }

    public String createSubModelFile() {
        String subModelFileHeader = "";
        String subModelFileBody = "";
        String identificationStr = "";
        if (!this.subModel.getIdentification().getIdType().toString().isEmpty() && !this.subModel.getIdentification().getIdentifier().isEmpty()) {
            identificationStr = "\t\tsetIdentification(IdentifierType." + this.subModel.getIdentification().getIdType().toString() + ", AASServer.getSettings().SUBMODEL_" + this.subModel.getIdShort().toUpperCase() + "_" + this.subModel.getIdentification().getIdType().toString() + ".get().toString()); \r\n";
        } else {
            logger.error("No Submodel identification information found. Or Identification information incomplete.");
        }
        ArrayList<Operation> retrievedOps = new ArrayList();
        for (SubModelElementCollection sec : this.subModelElementCollections) {
            retrievedOps = this.retrieveOperations(sec);
        }
        String operationFieldVariables = this.generateOperationFields(this.operations);
        operationFieldVariables = String.valueOf(operationFieldVariables) + this.generateOperationFields(retrievedOps);
        String idShortStr = "\t\tsetIdShort(\"" + this.subModel.getIdShort() + "\");\r\n";
        subModelFileHeader = "/*******************************************************************************\n * Copyright (c) " + this.year + " DFKI.\n" + " *\n" + " * This program and the accompanying materials\n" + " * are made available under the terms of the Eclipse Public License 2.0\n" + " * which accompanies this distribution, and is available at\n" + " * https://www.eclipse.org/legal/epl-2.0/\n" + " *\n" + " * SPDX-License-Identifier: EPL-2.0\n" + " *\n" + " * Contributors:\n" + " *     DFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\n" + " *******************************************************************************/ \r\n" + "package " + this.nameSpace + ".module.submodels." + this.subModel.getIdShort().toLowerCase() + ";\r\n" + "\r\nimport java.util.function.Function;\r\n" + "import java.util.stream.Collectors;\r\n" + "import java.util.ArrayList;\r\n" + "import java.util.Collection;\r\n" + "import java.util.HashMap;\r\n" + "import java.util.LinkedHashMap;\r\n" + "import java.util.Map;\r\n" + "import java.util.List;\r\n" + "\r\n" + "import java.math.BigInteger; \r\n" + "\r\n" + "import javax.xml.datatype.XMLGregorianCalendar;\r\n" + "import javax.xml.datatype.Duration;\r\n" + "import javax.xml.namespace.QName;\r\n" + "\r\n" + "import " + this.nameSpace + ".connection.ConnectedDevices;\r\n" + "//import " + this.nameSpace + ".connection.DataCrawler;\r\n" + "import " + this.nameSpace + ".module.AASServer;\r\n" + "import " + this.nameSpace + ".module.ConceptDescriptions;\r\n" + "import " + this.nameSpace + ".connection.OpcUaVariable;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.reference.Key; \r\n" + "import org.eclipse.basyx.submodel.metamodel.map.reference.Reference; \r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements; \r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType; \r\n" + "import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.Submodel;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;\r\n" + "import com.festo.aas.p4m.connection.ValueDelegate; \r\n" + "import org.eclipse.basyx.vab.protocol.opcua.types.NodeId;\r\n" + "import org.eclipse.basyx.vab.protocol.opcua.types.UnsignedShort;\r\n" + "import com.festo.aas.p4m.connection.ConnectedProperty;\r\n" + "\r\n" + "/**\r\n" + " * \r\n" + " * @author DFKI\r\n" + " * \r\n" + " * Do not edit this file for changing operation behaviours. \r\n" + " */\r\n" + "\r\n" + "public class " + this.subModel.getIdShort() + " extends Submodel {\r\n" + "\r\n" + "\t/**\r\n" + "\t * This field variable holds all configured connectors to the asset. \r\n" + "\t * Use these connectors to communicate with your asset.\r\n" + "\t */" + "\r\n" + "\tprivate ConnectedDevices connectedDevices;\r\n" + "\r\n" + "\tprivate ConceptDescriptions conceptDescriptions;\r\n" + "\r\n" + "\t/**\r\n" + "     * This class contains all user-provided code for operations.\r\n" + "     */\r\n" + "\tprivate final " + "DynamicElementsWorkspace " + "dew; \r\n" + "\r\n" + "\t /**\r\n" + "     * This class contains all user-provided code for value delegates.\r\n" + "     */\r\n" + "\r\n" + "\t /**\r\n" + "     * The following contains the declaration of the operation variables as field variables so that they can be accessed in their true sense.\r\n" + "     */\r\n" + operationFieldVariables + "\r\n" + "\r\n" + "\tpublic " + this.subModel.getIdShort() + "() {\r\n" + "\r\n" + "\t\ttry {\r\n" + "\t\t\tconnectedDevices = new ConnectedDevices();\r\n" + "\t\t} \r\n" + "\t\tcatch (Exception e) {\r\n" + "\r\n" + "\t\t\te.printStackTrace();\r\n" + "\t\t}\r\n" + "\t\t\r\n" + "\t\t" + "dew = new " + "DynamicElementsWorkspace(connectedDevices);\r\n" + "\t\t" + "conceptDescriptions = new " + "ConceptDescriptions();\r\n" + "\r\n";
        subModelFileBody = String.valueOf(idShortStr) + identificationStr + this.generateModelingInfo() + this.generateSemanticReference();
        for (Operation operation : this.operations) {
            OperationGenerator opGen = new OperationGenerator(operation);
            subModelFileBody = String.valueOf(subModelFileBody) + opGen.generateOperation();
        }
        for (Property property : this.properties) {
            PropertyGenerator propGen = new PropertyGenerator(property);
            subModelFileBody = String.valueOf(subModelFileBody) + propGen.generateProperty();
        }
        for (File file : this.files) {
            FileGenerator fileGen = new FileGenerator(file);
            subModelFileBody = String.valueOf(subModelFileBody) + fileGen.generateFile();
        }
        for (MultiLanguageProperty multiLangProperty : this.multiLanguageProperties) {
            MLPGenerator mlpGen = new MLPGenerator(multiLangProperty);
            subModelFileBody = String.valueOf(subModelFileBody) + mlpGen.generateMultiLanguageProperty();
        }
        for (SubModelElementCollection subModelElementCollection : this.subModelElementCollections) {
            SECGenerator secGen = new SECGenerator(subModelElementCollection);
            subModelFileBody = String.valueOf(subModelFileBody) + secGen.generateSubModelElementCollection();
        }
        subModelFileBody = String.valueOf(subModelFileBody) + "\t}\r\n\t\r\n}\r\n";
        String subModelText = String.valueOf(subModelFileHeader) + subModelFileBody;
        logger.info("SubModel Code for SubModel: " + this.subModel.getIdShort() + " generated.");
        return subModelText;
    }

    private String generateModelingInfo() {
        String setKind = "";
        if (!this.subModel.getKind().toString().isEmpty()) {
            setKind = "\t\tsetKind(ModelingKind." + this.subModel.getKind().toString() + "); \r\n";
        } else {
            logger.error("No Submodel ModelingKind information found.");
        }
        return setKind;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.subModel.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                if (key.getType() != null) {
                    String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                    semanticStr = String.valueOf(semanticStr) + "\t\t" + this.subModel.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
                    continue;
                }
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.subModel.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + "GLOBALREFERENCE" + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.subModel.getIdShort() + "Ref = new Reference(" + this.subModel.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\tsetSemanticId(" + this.subModel.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for Submodel: " + this.subModel.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tsetSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for Submodel: " + this.subModel.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }

    private String generateOperationFields(List<Operation> operations) {
        String operationFieldVariables = "";
        for (Operation operation : operations) {
            OperationGenerator opGen = new OperationGenerator(operation);
            operationFieldVariables = String.valueOf(operationFieldVariables) + opGen.generateOperationFieldVariables();
        }
        return operationFieldVariables;
    }

    private List<Operation> retrieveOperations(SubModelElementCollection sec) {
        ArrayList<Operation> retrievedOps = new ArrayList<Operation>();
        if (sec.getOperations() != null) {
            for (Operation operation : sec.getOperations()) {
                retrievedOps.add(operation);
            }
        }
        if (sec.getSubModelElementCollections() != null) {
            for (SubModelElementCollection collection : sec.getSubModelElementCollections()) {
                List<Operation> ops = this.retrieveOperations(collection);
                for (Operation op : ops) {
                    retrievedOps.add(op);
                }
            }
        }
        return retrievedOps;
    }
}

