/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.JavaGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassAttributesDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassImportClassDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassOperationsDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaEnumerations;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaImportUtil;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaInnerClassifiers;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.StaticClassifier;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Strictfp;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaClassifierGenerator {
    public static List<String> getSortedIncludePathList(Classifier classifier, String prefix) {
        List importPathList = IterableExtensions.sort(JavaClassImportClassDeclaration.javaClassAllImports(classifier, prefix));
        return importPathList;
    }

    public static CharSequence generateClassCode(Classifier classifier, IProject project, String prefix) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageDeclaration = JavaClassifierGenerator.packageDeclaration(classifier, project, prefix);
        _builder.append(_packageDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.newLine();
        String _javaImport = JavaImportUtil.javaImport((NamedElement)classifier, project);
        _builder.append(_javaImport);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        JavaGenUtils.openNS((NamedElement)classifier);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t");
        String _classVisibility = JavaClassifierGenerator.classVisibility(classifier);
        _builder.append(_classVisibility, "\t\t\t\t\t\t\t\t");
        _builder.append(" ");
        String _classModifiers = JavaClassifierGenerator.classModifiers(classifier);
        _builder.append(_classModifiers, "\t\t\t\t\t\t\t\t");
        String _classifierType = JavaClassifierGenerator.classifierType(classifier);
        _builder.append(_classifierType, "\t\t\t\t\t\t\t\t");
        _builder.append(" DynamicElementsWorkspace");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        if (classifier instanceof Enumeration) {
            CharSequence _javaEnumerationLiterals = JavaEnumerations.javaEnumerationLiterals((Enumeration)classifier);
            _builder.append((Object)_javaEnumerationLiterals, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t");
        String _javaClassprivateAttributesDeclaration = JavaClassAttributesDeclaration.javaClassprivateAttributesDeclaration();
        _builder.append(_javaClassprivateAttributesDeclaration, "\t\t\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _javaClassConstructorDeclaration = JavaClassOperationsDeclaration.javaClassConstructorDeclaration(classifier);
        _builder.append(_javaClassConstructorDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _javaClassOperationsDeclaration = JavaClassOperationsDeclaration.javaClassOperationsDeclaration(classifier);
        _builder.append((Object)_javaClassOperationsDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _javaClassPropertyAttributesDeclaration = JavaClassAttributesDeclaration.javaClassPropertyAttributesDeclaration(classifier);
        _builder.append((Object)_javaClassPropertyAttributesDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _javaInnerSECClassDefinition = JavaInnerClassifiers.javaInnerSECClassDefinition(classifier);
        _builder.append((Object)_javaInnerSECClassDefinition, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String classifierType(Classifier classifier) {
        if (classifier instanceof Interface) {
            return "interface";
        }
        if (classifier instanceof Enumeration) {
            return "enum";
        }
        return "class";
    }

    public static String classVisibility(Classifier classifier) {
        Element _owner = classifier.getOwner();
        if (_owner instanceof Classifier) {
            return classifier.getVisibility().toString().toLowerCase();
        }
        VisibilityKind _visibility = classifier.getVisibility();
        boolean _equals = Objects.equal((Object)_visibility, (Object)VisibilityKind.PUBLIC_LITERAL);
        if (_equals) {
            return "public";
        }
        return "";
    }

    public static String classModifiers(Classifier classifier) {
        Strictfp _stereotypeApplication_1;
        boolean _tripleNotEquals_1;
        Element _owner;
        String result = "";
        if (!(classifier instanceof Enumeration) && !(classifier instanceof Interface)) {
            boolean _isAbstract = classifier.isAbstract();
            if (_isAbstract) {
                String _result = result;
                result = String.valueOf(_result) + "abstract ";
            } else {
                boolean _isLeaf = classifier.isLeaf();
                if (_isLeaf) {
                    String _result_1 = result;
                    result = String.valueOf(_result_1) + "final ";
                }
            }
        }
        if ((_owner = classifier.getOwner()) instanceof Classifier) {
            boolean _tripleNotEquals;
            StaticClassifier _stereotypeApplication = (StaticClassifier)UMLUtil.getStereotypeApplication((Element)classifier, StaticClassifier.class);
            boolean bl = _tripleNotEquals = _stereotypeApplication != null;
            if (_tripleNotEquals) {
                String _result_2 = result;
                result = String.valueOf(_result_2) + "static ";
            }
        }
        boolean bl = _tripleNotEquals_1 = (_stereotypeApplication_1 = (Strictfp)UMLUtil.getStereotypeApplication((Element)classifier, Strictfp.class)) != null;
        if (_tripleNotEquals_1) {
            String _result_3 = result;
            result = String.valueOf(_result_3) + "strictfp ";
        }
        return result;
    }

    public static String packageDeclaration(Classifier classifier, IProject project, String prefix) {
        boolean _isEmpty;
        String _fullPath = JavaGenUtils.getFullPath(classifier, project, ".", false);
        String qName = String.valueOf(prefix) + _fullPath;
        boolean _endsWith = qName.endsWith(".");
        if (_endsWith) {
            int _length = qName.length();
            int _minus = _length - 1;
            qName = qName.substring(0, _minus);
        }
        if (_isEmpty = qName.isEmpty()) {
            return "";
        }
        String _lowerCase = classifier.getName().toLowerCase();
        String _plus = "package " + qName + "." + _lowerCase;
        return String.valueOf(_plus) + ";";
    }
}

