/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.widgets;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.aas.AASFactory;
import org.eclipse.papyrus.aas.AASPackage;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.papyrus.aas.DataElement;
import org.eclipse.papyrus.aas.Endpoint;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.papyrus.aas.ProtocolKind;
import org.eclipse.papyrus.aas.Submodel;
import org.eclipse.papyrus.aas.SubmodelElement;
import org.eclipse.papyrus.aas.ui.utils.AASUtils;
import org.eclipse.papyrus.aas.ui.widgets.MultiplicityElementAdapter;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class EndPointObservableValue
extends PapyrusObservableValue
implements IObserving {
    private DataElement propertyElement;
    private PartAdapter partAdapter;
    private Object value;

    public EndPointObservableValue(EObject property, TransactionalEditingDomain domain) {
        super(property, (EStructuralFeature)AASPackage.eINSTANCE.getSubmodelElement_EndPoint(), (EditingDomain)domain);
        if (property instanceof DataElement) {
            this.propertyElement = (DataElement)property;
        }
        ((PartAdapter)this.getPartAdapter()).adapt((Notifier)this.propertyElement);
        if (property instanceof Element && AASUtils.hasSemantics(property)) {
            this.propertyElement = (DataElement)UMLUtil.getStereotypeApplication((Element)((Element)property), Property.class);
            ((PartAdapter)this.getPartAdapter()).adapt((Notifier)this.propertyElement);
        }
    }

    public synchronized void dispose() {
        try {
            if (this.partAdapter != null) {
                if (this.partAdapter.getTarget() != null) {
                    this.partAdapter.unadapt((Notifier)this.partAdapter.getTarget());
                }
                this.partAdapter = null;
            }
            this.value = null;
        }
        finally {
            super.dispose();
        }
    }

    protected Object doGetValue() {
        Asset asset;
        Submodel aasSubmodel;
        Endpoint end = this.propertyElement.getEndPoint();
        Endpoint result = null;
        if (this.value != null && end instanceof Endpoint && this.getAssetfromSubmodel(aasSubmodel = (Submodel)UMLUtil.getStereotypeApplication((Element)EndPointObservableValue.getSubmodel((Element)this.propertyElement.getBase_Property().eContainer()), Submodel.class)) != null && (asset = this.getAssetfromSubmodel(aasSubmodel)).getEndpoint() != null && !asset.getEndpoint().isEmpty()) {
            for (Endpoint ep : asset.getEndpoint()) {
                if (ep.getAddress() == null || ep.getName() == null || ep.getProtocol() == null || !ep.getAddress().equals(end.getAddress()) || !ep.getName().equals(end.getName()) || !ep.getProtocol().equals((Object)end.getProtocol())) continue;
                result = ep;
            }
        }
        if (result != null) {
            String valueString = end.toString();
            String endpointParameter = valueString.split("[()]")[1];
            String endpointwithequals = endpointParameter.replace(": ", "=");
            this.value = "(" + endpointwithequals + ")";
        } else {
            this.value = "Please Select in the list bellow an endpoint from the Asset's endpoints";
        }
        return this.value;
    }

    public Asset getAssetfromSubmodel(Submodel submodel) {
        List possibleAasContainers = this.propertyElement.getBase_Property().getModel().allOwnedElements().stream().filter(e -> UMLUtil.getStereotypeApplication((Element)e, AssetAdministrationShell.class) != null).collect(Collectors.toList());
        if (possibleAasContainers != null && !possibleAasContainers.isEmpty()) {
            for (Element element : possibleAasContainers) {
                AssetAdministrationShell ass = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)element, AssetAdministrationShell.class);
                if (ass == null || !ass.getSubmodel().contains((Object)submodel)) continue;
                return ass.getAsset();
            }
        }
        return null;
    }

    public Command getCommand(Object value) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (value != null && value instanceof String) {
            result = !value.equals("") && !value.equals("Please Select in the list bellow an endpoint from the Asset's endpoints") ? this.getChangEndPointCommand(this.propertyElement, (String)value, this.domain) : this.getUnsetEndPointCommand((SubmodelElement)this.propertyElement);
        }
        if (value instanceof Endpoint) {
            result = this.getChangEndPointCommand2(this.propertyElement, (Endpoint)value, this.domain);
        }
        return result;
    }

    private Endpoint getEndpoint(String endpoint) {
        if (endpoint != "") {
            Endpoint endPoint = AASFactory.eINSTANCE.createEndpoint();
            String[] propertiesValues = endpoint.substring(1, endpoint.length() - 1).split(",");
            int i = 0;
            while (i < propertiesValues.length) {
                propertiesValues[i] = propertiesValues[i].split("=")[1];
                ++i;
            }
            endPoint.setAddress(propertiesValues[0]);
            endPoint.setName(propertiesValues[2]);
            endPoint.setProtocol(ProtocolKind.get((String)propertiesValues[1]));
            return endPoint;
        }
        return null;
    }

    private String getStringfromEndpoint(Endpoint endpoint) {
        if (endpoint != null) {
            return endpoint.toString();
        }
        return "";
    }

    protected Command getUnsetEndPointCommand(SubmodelElement element) {
        ICommand result = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)element);
        if (provider != null) {
            TransactionalEditingDomain ted = (TransactionalEditingDomain)this.domain;
            Endpoint upperValue = element.getEndPoint();
            if (upperValue != null) {
                result = provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(ted, (EObject)upperValue, false));
            }
        }
        return result == null ? UnexecutableCommand.INSTANCE : GMFtoEMFCommandWrapper.wrap(result);
    }

    private Command getChangEndPointCommand(DataElement property, String value, EditingDomain domain) {
        ICommand result = null;
        Endpoint endPoint = AASFactory.eINSTANCE.createEndpoint();
        String[] propertiesValues = value.substring(1, value.length() - 1).split(",");
        int i = 0;
        while (i < propertiesValues.length) {
            propertiesValues[i] = propertiesValues[i].split("=")[1];
            ++i;
        }
        endPoint.setAddress(propertiesValues[0]);
        endPoint.setName(propertiesValues[2]);
        endPoint.setProtocol(ProtocolKind.get((String)propertiesValues[1]));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)property);
        if (provider != null) {
            IEditCommandRequest request = this.createSetRequest((TransactionalEditingDomain)domain, (EObject)property, (EStructuralFeature)AASPackage.eINSTANCE.getSubmodelElement_EndPoint(), endPoint);
            result = provider.getEditCommand(request);
        }
        return result == null ? UnexecutableCommand.INSTANCE : GMFtoEMFCommandWrapper.wrap(result);
    }

    private Command getChangEndPointCommand2(DataElement property, Endpoint endPoint, EditingDomain domain) {
        ICommand result = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)property);
        if (provider != null) {
            IEditCommandRequest request = this.createSetRequest((TransactionalEditingDomain)domain, (EObject)property, (EStructuralFeature)AASPackage.eINSTANCE.getSubmodelElement_EndPoint(), endPoint);
            result = provider.getEditCommand(request);
        }
        return result == null ? UnexecutableCommand.INSTANCE : GMFtoEMFCommandWrapper.wrap(result);
    }

    protected IEditCommandRequest createSetRequest(TransactionalEditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetRequest(domain, owner, feature, value);
    }

    public Object getObserved() {
        return this.propertyElement;
    }

    public Object getValueType() {
        return String.class;
    }

    private Adapter getPartAdapter() {
        if (this.partAdapter == null) {
            this.partAdapter = new PartAdapter();
        }
        return this.partAdapter;
    }

    /*
     * Unable to fully structure code
     */
    private static Element getSubmodel(Element element) {
        owner = element;
        if (!EndPointObservableValue.isSubmodel(owner).booleanValue()) ** GOTO lbl5
        return element;
lbl-1000:
        // 1 sources

        {
            owner = owner.getOwner();
lbl5:
            // 2 sources

            ** while (!EndPointObservableValue.isSubmodel((Element)owner).booleanValue())
        }
lbl6:
        // 1 sources

        return owner;
    }

    public static Boolean isSubmodel(Element c) {
        if (UMLUtil.getStereotypeApplication((Element)c, Submodel.class) != null) {
            return true;
        }
        return false;
    }

    private class PartAdapter
    extends MultiplicityElementAdapter {
        @Override
        public void handleMultiplicityChanged(Notification notification) {
            Object oldValue = EndPointObservableValue.this.value;
            Object newValue = EndPointObservableValue.this.doGetValue();
            if (!newValue.equals(oldValue)) {
                final ValueDiff diff = Diffs.createValueDiff((Object)oldValue, (Object)newValue);
                EndPointObservableValue.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        EndPointObservableValue.this.fireValueChange(diff);
                    }
                });
            }
        }
    }
}

