/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtocolKind implements Enumerator
{
    HTTP(0, "HTTP", "HTTP"),
    MQTT(1, "MQTT", "MQTT"),
    OPCUA(2, "OPCUA", "OPCUA"),
    CO_AP(3, "CoAP", "CoAP"),
    OTHER(4, "OTHER", "OTHER");

    public static final int HTTP_VALUE = 0;
    public static final int MQTT_VALUE = 1;
    public static final int OPCUA_VALUE = 2;
    public static final int CO_AP_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final ProtocolKind[] VALUES_ARRAY;
    public static final List<ProtocolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProtocolKind[]{HTTP, MQTT, OPCUA, CO_AP, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProtocolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolKind get(int value) {
        switch (value) {
            case 0: {
                return HTTP;
            }
            case 1: {
                return MQTT;
            }
            case 2: {
                return OPCUA;
            }
            case 3: {
                return CO_AP;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private ProtocolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

