/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LocalKeyType implements Enumerator
{
    ID_SHORT(0, "IdShort", "IdShort"),
    FRAGMENT_ID(1, "FragmentId", "FragmentId");

    public static final int ID_SHORT_VALUE = 0;
    public static final int FRAGMENT_ID_VALUE = 1;
    private static final LocalKeyType[] VALUES_ARRAY;
    public static final List<LocalKeyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LocalKeyType[]{ID_SHORT, FRAGMENT_ID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LocalKeyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LocalKeyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LocalKeyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LocalKeyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LocalKeyType get(int value) {
        switch (value) {
            case 0: {
                return ID_SHORT;
            }
            case 1: {
                return FRAGMENT_ID;
            }
        }
        return null;
    }

    private LocalKeyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

