/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ClassInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new ClassDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class ClassDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private EObject newSemanticContainer;

        ClassDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseInterface(Interface inter) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseSignal(Signal signal) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseClass(Class clazz) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseComment(Comment comment) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseDataType(DataType dataType) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseEnumeration(Enumeration enumeration) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
            CheckStatus result = !(this.newSemanticContainer instanceof Enumeration) ? CheckStatus.no("EnumerationLiteral can only be drag and drop on Enumeration.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseReception(Reception reception) {
            CheckStatus result = !(this.newSemanticContainer instanceof Class) && !(this.newSemanticContainer instanceof Interface) ? CheckStatus.no("Reception can only be drag and drop on Class or Interface.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseOperation(Operation operation) {
            boolean isOperationHolder = this.newSemanticContainer instanceof Class || this.newSemanticContainer instanceof Interface || this.newSemanticContainer instanceof DataType;
            CheckStatus result = !isOperationHolder || this.newSemanticContainer instanceof Enumeration ? CheckStatus.no("Operation can only be drag and drop on a Class, an Interface, a PrimitiveType or a DataType.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus casePackage(Package pack) {
            return this.handlePackageContainer();
        }

        public CheckStatus casePrimitiveType(PrimitiveType primitiveType) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseProperty(Property property) {
            boolean isPropertyHolder = this.newSemanticContainer instanceof Class || this.newSemanticContainer instanceof Interface || this.newSemanticContainer instanceof DataType || this.newSemanticContainer instanceof Signal;
            CheckStatus result = !isPropertyHolder || this.newSemanticContainer instanceof Enumeration ? CheckStatus.no("Property can only be drag and drop on a Class, an Interface, a DataType, a PrimitiveType or a Signal.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }

        private CheckStatus handlePackageContainer() {
            CheckStatus result = !(this.newSemanticContainer instanceof Package) ? CheckStatus.no(MessageFormat.format("{0} can only be drag and drop on a Package kind element.", this.newSemanticContainer.eClass().getName())) : CheckStatus.YES;
            return result;
        }
    }
}

