/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.Activator;

public class BareCTFCmd {
    protected static final String CONFIG_YAML = "config.yaml";
    protected static final String BARECTFCMD = "barectf";
    ProcessBuilder pb = new ProcessBuilder(new String[0]);

    public BareCTFCmd() {
        this.pb.command().add(BARECTFCMD);
        this.pb.command().add(CONFIG_YAML);
    }

    public Process start(IFolder folder) throws IOException, CoreException {
        this.pb.directory(folder.getLocation().toFile());
        Process process = this.pb.start();
        InputStream es = process.getErrorStream();
        if (es.read() != -1) {
            String errorMsg;
            BufferedReader errors = new BufferedReader(new InputStreamReader(es));
            StringBuffer errorMsgs = new StringBuffer();
            while (errors.ready() && (errorMsg = errors.readLine()) != null) {
                if (errorMsgs == null) continue;
                errorMsgs.append(errorMsg);
                errorMsgs.append("\n");
            }
            Activator.log.warn(errorMsgs.toString());
            errors.close();
        } else {
            String[] genFiles;
            String baseFN = folder.getFullPath().toString() + "/";
            String[] stringArray = genFiles = new String[]{"barectf.c", "barectf.h", "barectf-bitfield.c", "barectf-bitfield.h", "metadata"};
            int n = genFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String genFile = stringArray[n2];
                TransformationContext.current.keepFiles.add(baseFN + genFile);
                ++n2;
            }
        }
        folder.refreshLocal(1, null);
        return process;
    }

    public List<String> command() {
        return this.pb.command();
    }
}

